/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionVisitorBase;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.customobject.QuantileDigest;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.utils.DataSchema;

public class PercentileEstAggregationFunction
implements AggregationFunction<QuantileDigest, Long> {
    public static final double DEFAULT_MAX_ERROR = 0.05;
    protected final int _percentile;

    public PercentileEstAggregationFunction(int percentile) {
        this._percentile = percentile;
    }

    @Override
    @Nonnull
    public AggregationFunctionType getType() {
        return AggregationFunctionType.PERCENTILEEST;
    }

    @Override
    @Nonnull
    public String getColumnName(@Nonnull String column) {
        return AggregationFunctionType.PERCENTILEEST.getName() + this._percentile + "_" + column;
    }

    @Override
    public void accept(@Nonnull AggregationFunctionVisitorBase visitor) {
        visitor.visit(this);
    }

    @Override
    @Nonnull
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    @Nonnull
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, @Nonnull AggregationResultHolder aggregationResultHolder, BlockValSet ... blockValSets) {
        QuantileDigest quantileDigest = PercentileEstAggregationFunction.getQuantileDigest(aggregationResultHolder);
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                double[] valueArray = blockValSets[0].getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    quantileDigest.add((long)valueArray[i]);
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSets[0].getBytesValuesSV();
                for (int i = 0; i < length; ++i) {
                    quantileDigest.merge(ObjectSerDeUtils.QUANTILE_DIGEST_SER_DE.deserialize(bytesValues[i]));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for PERCENTILE_EST aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, @Nonnull int[] groupKeyArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                double[] valueArray = blockValSets[0].getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    QuantileDigest quantileDigest = PercentileEstAggregationFunction.getQuantileDigest(groupByResultHolder, groupKeyArray[i]);
                    quantileDigest.add((long)valueArray[i]);
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSets[0].getBytesValuesSV();
                for (int i = 0; i < length; ++i) {
                    QuantileDigest quantileDigest = PercentileEstAggregationFunction.getQuantileDigest(groupByResultHolder, groupKeyArray[i]);
                    quantileDigest.merge(ObjectSerDeUtils.QUANTILE_DIGEST_SER_DE.deserialize(bytesValues[i]));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for PERCENTILE_EST aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, @Nonnull int[][] groupKeysArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                double[] valueArray = blockValSets[0].getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    double value = valueArray[i];
                    for (int groupKey : groupKeysArray[i]) {
                        QuantileDigest quantileDigest = PercentileEstAggregationFunction.getQuantileDigest(groupByResultHolder, groupKey);
                        quantileDigest.add((long)value);
                    }
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSets[0].getBytesValuesSV();
                for (int i = 0; i < length; ++i) {
                    QuantileDigest value = ObjectSerDeUtils.QUANTILE_DIGEST_SER_DE.deserialize(bytesValues[i]);
                    for (int groupKey : groupKeysArray[i]) {
                        QuantileDigest quantileDigest = PercentileEstAggregationFunction.getQuantileDigest(groupByResultHolder, groupKey);
                        quantileDigest.merge(value);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for PERCENTILE_EST aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    @Override
    @Nonnull
    public QuantileDigest extractAggregationResult(@Nonnull AggregationResultHolder aggregationResultHolder) {
        QuantileDigest quantileDigest = (QuantileDigest)aggregationResultHolder.getResult();
        if (quantileDigest == null) {
            return new QuantileDigest(0.05);
        }
        return quantileDigest;
    }

    @Override
    @Nonnull
    public QuantileDigest extractGroupByResult(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey) {
        QuantileDigest quantileDigest = (QuantileDigest)groupByResultHolder.getResult(groupKey);
        if (quantileDigest == null) {
            return new QuantileDigest(0.05);
        }
        return quantileDigest;
    }

    @Override
    @Nonnull
    public QuantileDigest merge(@Nonnull QuantileDigest intermediateResult1, @Nonnull QuantileDigest intermediateResult2) {
        intermediateResult1.merge(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return false;
    }

    @Override
    @Nonnull
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    @Nonnull
    public Long extractFinalResult(@Nonnull QuantileDigest intermediateResult) {
        return intermediateResult.getQuantile((double)this._percentile / 100.0);
    }

    protected static QuantileDigest getQuantileDigest(@Nonnull AggregationResultHolder aggregationResultHolder) {
        QuantileDigest quantileDigest = (QuantileDigest)aggregationResultHolder.getResult();
        if (quantileDigest == null) {
            quantileDigest = new QuantileDigest(0.05);
            aggregationResultHolder.setValue(quantileDigest);
        }
        return quantileDigest;
    }

    protected static QuantileDigest getQuantileDigest(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey) {
        QuantileDigest quantileDigest = (QuantileDigest)groupByResultHolder.getResult(groupKey);
        if (quantileDigest == null) {
            quantileDigest = new QuantileDigest(0.05);
            groupByResultHolder.setValueForKey(groupKey, quantileDigest);
        }
        return quantileDigest;
    }
}

