/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.PercentileEstAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.customobject.QuantileDigest;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;

public class PercentileEstMVAggregationFunction
extends PercentileEstAggregationFunction {
    public PercentileEstMVAggregationFunction(int percentile) {
        super(percentile);
    }

    @Override
    @Nonnull
    public AggregationFunctionType getType() {
        return AggregationFunctionType.PERCENTILEESTMV;
    }

    @Override
    @Nonnull
    public String getColumnName(@Nonnull String column) {
        return AggregationFunctionType.PERCENTILEEST.getName() + this._percentile + "MV_" + column;
    }

    @Override
    public void aggregate(int length, @Nonnull AggregationResultHolder aggregationResultHolder, BlockValSet ... blockValSets) {
        double[][] valuesArray = blockValSets[0].getDoubleValuesMV();
        QuantileDigest quantileDigest = PercentileEstMVAggregationFunction.getQuantileDigest(aggregationResultHolder);
        for (int i = 0; i < length; ++i) {
            for (double value : valuesArray[i]) {
                quantileDigest.add((long)value);
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, @Nonnull int[] groupKeyArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        double[][] valuesArray = blockValSets[0].getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            QuantileDigest quantileDigest = PercentileEstMVAggregationFunction.getQuantileDigest(groupByResultHolder, groupKeyArray[i]);
            for (double value : valuesArray[i]) {
                quantileDigest.add((long)value);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, @Nonnull int[][] groupKeysArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        double[][] valuesArray = blockValSets[0].getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            double[] values = valuesArray[i];
            for (int groupKey : groupKeysArray[i]) {
                QuantileDigest quantileDigest = PercentileEstMVAggregationFunction.getQuantileDigest(groupByResultHolder, groupKey);
                for (double value : values) {
                    quantileDigest.add((long)value);
                }
            }
        }
    }
}

