/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.PercentileAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;

public class PercentileMVAggregationFunction
extends PercentileAggregationFunction {
    public PercentileMVAggregationFunction(int percentile) {
        super(percentile);
    }

    @Override
    @Nonnull
    public AggregationFunctionType getType() {
        return AggregationFunctionType.PERCENTILEMV;
    }

    @Override
    @Nonnull
    public String getColumnName(@Nonnull String column) {
        return AggregationFunctionType.PERCENTILE.getName() + this._percentile + "MV_" + column;
    }

    @Override
    public void aggregate(int length, @Nonnull AggregationResultHolder aggregationResultHolder, BlockValSet ... blockValSets) {
        double[][] valuesArray = blockValSets[0].getDoubleValuesMV();
        DoubleArrayList valueList = PercentileMVAggregationFunction.getValueList(aggregationResultHolder);
        for (int i = 0; i < length; ++i) {
            for (double value : valuesArray[i]) {
                valueList.add(value);
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, @Nonnull int[] groupKeyArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        double[][] valuesArray = blockValSets[0].getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            DoubleArrayList valueList = PercentileMVAggregationFunction.getValueList(groupByResultHolder, groupKeyArray[i]);
            for (double value : valuesArray[i]) {
                valueList.add(value);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, @Nonnull int[][] groupKeysArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        double[][] valuesArray = blockValSets[0].getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            double[] values = valuesArray[i];
            for (int groupKey : groupKeysArray[i]) {
                DoubleArrayList valueList = PercentileMVAggregationFunction.getValueList(groupByResultHolder, groupKey);
                for (double value : values) {
                    valueList.add(value);
                }
            }
        }
    }
}

