/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import com.tdunning.math.stats.TDigest;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.PercentileTDigestAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;

public class PercentileTDigestMVAggregationFunction
extends PercentileTDigestAggregationFunction {
    public PercentileTDigestMVAggregationFunction(int percentile) {
        super(percentile);
    }

    @Override
    @Nonnull
    public AggregationFunctionType getType() {
        return AggregationFunctionType.PERCENTILETDIGESTMV;
    }

    @Override
    @Nonnull
    public String getColumnName(@Nonnull String column) {
        return AggregationFunctionType.PERCENTILETDIGEST.getName() + this._percentile + "MV_" + column;
    }

    @Override
    public void aggregate(int length, @Nonnull AggregationResultHolder aggregationResultHolder, BlockValSet ... blockValSets) {
        double[][] valuesArray = blockValSets[0].getDoubleValuesMV();
        TDigest tDigest = PercentileTDigestMVAggregationFunction.getTDigest(aggregationResultHolder);
        for (int i = 0; i < length; ++i) {
            for (double value : valuesArray[i]) {
                tDigest.add(value);
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, @Nonnull int[] groupKeyArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        double[][] valuesArray = blockValSets[0].getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            TDigest tDigest = PercentileTDigestMVAggregationFunction.getTDigest(groupByResultHolder, groupKeyArray[i]);
            for (double value : valuesArray[i]) {
                tDigest.add(value);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, @Nonnull int[][] groupKeysArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        double[][] valuesArray = blockValSets[0].getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            double[] values = valuesArray[i];
            for (int groupKey : groupKeysArray[i]) {
                TDigest tDigest = PercentileTDigestMVAggregationFunction.getTDigest(groupByResultHolder, groupKey);
                for (double value : values) {
                    tDigest.add(value);
                }
            }
        }
    }
}

