/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.DoubleAggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionVisitorBase;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.DoubleGroupByResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.common.utils.DataSchema;

public class SumAggregationFunction
implements AggregationFunction<Double, Double> {
    private static final double DEFAULT_VALUE = 0.0;

    @Override
    @Nonnull
    public AggregationFunctionType getType() {
        return AggregationFunctionType.SUM;
    }

    @Override
    @Nonnull
    public String getColumnName(@Nonnull String column) {
        return AggregationFunctionType.SUM.getName() + "_" + column;
    }

    @Override
    public void accept(@Nonnull AggregationFunctionVisitorBase visitor) {
        visitor.visit(this);
    }

    @Override
    @Nonnull
    public AggregationResultHolder createAggregationResultHolder() {
        return new DoubleAggregationResultHolder(0.0);
    }

    @Override
    @Nonnull
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new DoubleGroupByResultHolder(initialCapacity, maxCapacity, 0.0);
    }

    @Override
    public void aggregate(int length, @Nonnull AggregationResultHolder aggregationResultHolder, BlockValSet ... blockValSets) {
        double[] valueArray = blockValSets[0].getDoubleValuesSV();
        double sum = aggregationResultHolder.getDoubleResult();
        for (int i = 0; i < length; ++i) {
            sum += valueArray[i];
        }
        aggregationResultHolder.setValue(sum);
    }

    @Override
    public void aggregateGroupBySV(int length, @Nonnull int[] groupKeyArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        double[] valueArray = blockValSets[0].getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            int groupKey = groupKeyArray[i];
            groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + valueArray[i]);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, @Nonnull int[][] groupKeysArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        double[] valueArray = blockValSets[0].getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            double value = valueArray[i];
            for (int groupKey : groupKeysArray[i]) {
                groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + value);
            }
        }
    }

    @Override
    @Nonnull
    public Double extractAggregationResult(@Nonnull AggregationResultHolder aggregationResultHolder) {
        return aggregationResultHolder.getDoubleResult();
    }

    @Override
    @Nonnull
    public Double extractGroupByResult(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey) {
        return groupByResultHolder.getDoubleResult(groupKey);
    }

    @Override
    @Nonnull
    public Double merge(@Nonnull Double intermediateResult1, @Nonnull Double intermediateResult2) {
        return intermediateResult1 + intermediateResult2;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return true;
    }

    @Override
    @Nonnull
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    @Nonnull
    public Double extractFinalResult(@Nonnull Double intermediateResult) {
        return intermediateResult;
    }
}

