/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.SumAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;

public class SumMVAggregationFunction
extends SumAggregationFunction {
    @Override
    @Nonnull
    public AggregationFunctionType getType() {
        return AggregationFunctionType.SUMMV;
    }

    @Override
    @Nonnull
    public String getColumnName(@Nonnull String column) {
        return AggregationFunctionType.SUMMV.getName() + "_" + column;
    }

    @Override
    public void aggregate(int length, @Nonnull AggregationResultHolder aggregationResultHolder, BlockValSet ... blockValSets) {
        double[][] valuesArray = blockValSets[0].getDoubleValuesMV();
        double sum = aggregationResultHolder.getDoubleResult();
        for (int i = 0; i < length; ++i) {
            for (double value : valuesArray[i]) {
                sum += value;
            }
        }
        aggregationResultHolder.setValue(sum);
    }

    @Override
    public void aggregateGroupBySV(int length, @Nonnull int[] groupKeyArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        double[][] valuesArray = blockValSets[0].getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            int groupKey = groupKeyArray[i];
            double sum = groupByResultHolder.getDoubleResult(groupKey);
            for (double value : valuesArray[i]) {
                sum += value;
            }
            groupByResultHolder.setValueForKey(groupKey, sum);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, @Nonnull int[][] groupKeysArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        double[][] valuesArray = blockValSets[0].getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            double[] values = valuesArray[i];
            for (int groupKey : groupKeysArray[i]) {
                double sum = groupByResultHolder.getDoubleResult(groupKey);
                for (double value : values) {
                    sum += value;
                }
                groupByResultHolder.setValueForKey(groupKey, sum);
            }
        }
    }
}

