/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.customobject;

import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

public class MinMaxRangePair
implements Comparable<MinMaxRangePair> {
    private double _min;
    private double _max;

    public MinMaxRangePair(double min, double max) {
        this._min = min;
        this._max = max;
    }

    public void apply(double min, double max) {
        if (min < this._min) {
            this._min = min;
        }
        if (max > this._max) {
            this._max = max;
        }
    }

    public void apply(@Nonnull MinMaxRangePair minMaxRangePair) {
        if (minMaxRangePair._min < this._min) {
            this._min = minMaxRangePair._min;
        }
        if (minMaxRangePair._max > this._max) {
            this._max = minMaxRangePair._max;
        }
    }

    public double getMin() {
        return this._min;
    }

    public double getMax() {
        return this._max;
    }

    @Nonnull
    public byte[] toBytes() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.putDouble(this._min);
        byteBuffer.putDouble(this._max);
        return byteBuffer.array();
    }

    @Nonnull
    public static MinMaxRangePair fromBytes(byte[] bytes) {
        return MinMaxRangePair.fromByteBuffer(ByteBuffer.wrap(bytes));
    }

    @Nonnull
    public static MinMaxRangePair fromByteBuffer(ByteBuffer byteBuffer) {
        return new MinMaxRangePair(byteBuffer.getDouble(), byteBuffer.getDouble());
    }

    @Override
    public int compareTo(@Nonnull MinMaxRangePair minMaxRangePair) {
        double minMaxRange1 = this._max - this._min;
        double minMaxRange2 = minMaxRangePair._max - minMaxRangePair._min;
        if (minMaxRange1 > minMaxRange2) {
            return 1;
        }
        if (minMaxRange1 < minMaxRange2) {
            return -1;
        }
        return 0;
    }
}

