/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupKeyGenerator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.utils.ValueToIdMap;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.utils.ValueToIdMapFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.util.FixedIntArray;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.request.transform.TransformExpressionTree;

public class NoDictionaryMultiColumnGroupKeyGenerator
implements GroupKeyGenerator {
    private final TransformExpressionTree[] _groupByExpressions;
    private final int _numGroupByExpressions;
    private final FieldSpec.DataType[] _dataTypes;
    private final Dictionary[] _dictionaries;
    private final ValueToIdMap[] _onTheFlyDictionaries;
    private final Object2IntOpenHashMap<FixedIntArray> _groupKeyMap;
    private final int _globalGroupIdUpperBound;
    private int _numGroups = 0;

    public NoDictionaryMultiColumnGroupKeyGenerator(TransformOperator transformOperator, TransformExpressionTree[] groupByExpressions, int numGroupsLimit) {
        this._groupByExpressions = groupByExpressions;
        this._numGroupByExpressions = groupByExpressions.length;
        this._dataTypes = new FieldSpec.DataType[this._numGroupByExpressions];
        this._dictionaries = new Dictionary[this._numGroupByExpressions];
        this._onTheFlyDictionaries = new ValueToIdMap[this._numGroupByExpressions];
        for (int i = 0; i < this._numGroupByExpressions; ++i) {
            TransformExpressionTree groupByExpression = groupByExpressions[i];
            TransformResultMetadata transformResultMetadata = transformOperator.getResultMetadata(groupByExpression);
            this._dataTypes[i] = transformResultMetadata.getDataType();
            if (transformResultMetadata.hasDictionary()) {
                this._dictionaries[i] = transformOperator.getDictionary(groupByExpression);
                continue;
            }
            this._onTheFlyDictionaries[i] = ValueToIdMapFactory.get(this._dataTypes[i]);
        }
        this._groupKeyMap = new Object2IntOpenHashMap();
        this._groupKeyMap.defaultReturnValue(-1);
        this._globalGroupIdUpperBound = numGroupsLimit;
    }

    @Override
    public int getGlobalGroupKeyUpperBound() {
        return this._globalGroupIdUpperBound;
    }

    @Override
    public void generateKeysForBlock(@Nonnull TransformBlock transformBlock, @Nonnull int[] groupKeys) {
        int i;
        int numDocs = transformBlock.getNumDocs();
        Object[] values = new Object[this._numGroupByExpressions];
        for (i = 0; i < this._numGroupByExpressions; ++i) {
            BlockValSet blockValSet = transformBlock.getBlockValueSet(this._groupByExpressions[i]);
            values[i] = this._dictionaries[i] != null ? (Object)blockValSet.getDictionaryIdsSV() : this.getValuesFromBlockValSet(blockValSet, this._dataTypes[i]);
        }
        for (i = 0; i < numDocs; ++i) {
            int[] keys = new int[this._numGroupByExpressions];
            block9: for (int j = 0; j < this._numGroupByExpressions; ++j) {
                if (this._dictionaries[j] != null) {
                    int[] dictIds = (int[])values[j];
                    keys[j] = dictIds[i];
                    continue;
                }
                FieldSpec.DataType dataType = this._dataTypes[j];
                switch (dataType) {
                    case INT: {
                        int[] intValues = (int[])values[j];
                        keys[j] = this._onTheFlyDictionaries[j].put(intValues[i]);
                        continue block9;
                    }
                    case LONG: {
                        long[] longValues = (long[])values[j];
                        keys[j] = this._onTheFlyDictionaries[j].put(longValues[i]);
                        continue block9;
                    }
                    case FLOAT: {
                        float[] floatValues = (float[])values[j];
                        keys[j] = this._onTheFlyDictionaries[j].put(floatValues[i]);
                        continue block9;
                    }
                    case DOUBLE: {
                        double[] doubleValues = (double[])values[j];
                        keys[j] = this._onTheFlyDictionaries[j].put(doubleValues[i]);
                        continue block9;
                    }
                    case STRING: {
                        String[] stringValues = (String[])values[j];
                        keys[j] = this._onTheFlyDictionaries[j].put(stringValues[i]);
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal data type for no-dictionary key generator: " + (Object)((Object)dataType));
                    }
                }
            }
            groupKeys[i] = this.getGroupIdForKey(new FixedIntArray(keys));
        }
    }

    @Override
    public void generateKeysForBlock(@Nonnull TransformBlock transformBlock, @Nonnull int[][] groupKeys) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public int getCurrentGroupKeyUpperBound() {
        return this._groupKeyMap.size();
    }

    @Override
    public Iterator<GroupKeyGenerator.GroupKey> getUniqueGroupKeys() {
        return new GroupKeyIterator((Map<FixedIntArray, Integer>)this._groupKeyMap);
    }

    private int getGroupIdForKey(FixedIntArray keyList) {
        int groupId = this._groupKeyMap.getInt((Object)keyList);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups;
            this._groupKeyMap.put((Object)keyList, this._numGroups++);
        }
        return groupId;
    }

    private String buildStringKeyFromIds(FixedIntArray keyList) {
        StringBuilder builder = new StringBuilder();
        int[] keys = keyList.elements();
        for (int i = 0; i < keyList.size(); ++i) {
            int dictId = keys[i];
            String key = this._dictionaries[i] != null ? this._dictionaries[i].get(dictId).toString() : this._onTheFlyDictionaries[i].getString(dictId);
            if (i > 0) {
                builder.append("\t");
            }
            builder.append(key);
        }
        return builder.toString();
    }

    private Object getValuesFromBlockValSet(BlockValSet blockValSet, FieldSpec.DataType dataType) {
        Object[] values;
        switch (dataType) {
            case INT: {
                values = blockValSet.getIntValuesSV();
                break;
            }
            case LONG: {
                values = blockValSet.getLongValuesSV();
                break;
            }
            case FLOAT: {
                values = blockValSet.getFloatValuesSV();
                break;
            }
            case DOUBLE: {
                values = blockValSet.getDoubleValuesSV();
                break;
            }
            case STRING: {
                values = blockValSet.getStringValuesSV();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal data type for no-dictionary key generator: " + (Object)((Object)dataType));
            }
        }
        return values;
    }

    class GroupKeyIterator
    implements Iterator<GroupKeyGenerator.GroupKey> {
        Iterator<Map.Entry<FixedIntArray, Integer>> _iterator;
        GroupKeyGenerator.GroupKey _groupKey;

        public GroupKeyIterator(Map<FixedIntArray, Integer> map) {
            this._iterator = map.entrySet().iterator();
            this._groupKey = new GroupKeyGenerator.GroupKey();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public GroupKeyGenerator.GroupKey next() {
            Map.Entry<FixedIntArray, Integer> entry = this._iterator.next();
            this._groupKey._groupId = entry.getValue();
            this._groupKey._stringKey = NoDictionaryMultiColumnGroupKeyGenerator.this.buildStringKeyFromIds(entry.getKey());
            return this._groupKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

