/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby;

import it.unimi.dsi.fastutil.doubles.Double2IntMap;
import it.unimi.dsi.fastutil.doubles.Double2IntOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2IntMap;
import it.unimi.dsi.fastutil.floats.Float2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupKeyGenerator;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.request.transform.TransformExpressionTree;

public class NoDictionarySingleColumnGroupKeyGenerator
implements GroupKeyGenerator {
    private final TransformExpressionTree _groupByExpression;
    private final FieldSpec.DataType _dataType;
    private final Map _groupKeyMap;
    private final int _globalGroupIdUpperBound;
    private int _numGroups = 0;

    public NoDictionarySingleColumnGroupKeyGenerator(TransformOperator transformOperator, TransformExpressionTree groupByExpression, int numGroupsLimit) {
        this._groupByExpression = groupByExpression;
        this._dataType = transformOperator.getResultMetadata(this._groupByExpression).getDataType();
        this._groupKeyMap = this.createGroupKeyMap(this._dataType);
        this._globalGroupIdUpperBound = numGroupsLimit;
    }

    @Override
    public int getGlobalGroupKeyUpperBound() {
        return this._globalGroupIdUpperBound;
    }

    @Override
    public void generateKeysForBlock(@Nonnull TransformBlock transformBlock, @Nonnull int[] groupKeys) {
        BlockValSet blockValSet = transformBlock.getBlockValueSet(this._groupByExpression);
        int numDocs = transformBlock.getNumDocs();
        switch (this._dataType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                for (int i = 0; i < numDocs; ++i) {
                    groupKeys[i] = this.getKeyForValue(intValues[i]);
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < numDocs; ++i) {
                    groupKeys[i] = this.getKeyForValue(longValues[i]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < numDocs; ++i) {
                    groupKeys[i] = this.getKeyForValue(floatValues[i]);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < numDocs; ++i) {
                    groupKeys[i] = this.getKeyForValue(doubleValues[i]);
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSet.getStringValuesSV();
                for (int i = 0; i < numDocs; ++i) {
                    groupKeys[i] = this.getKeyForValue(stringValues[i]);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal data type for no-dictionary key generator: " + (Object)((Object)this._dataType));
            }
        }
    }

    private Map createGroupKeyMap(FieldSpec.DataType keyType) {
        Int2IntOpenHashMap map;
        switch (keyType) {
            case INT: {
                Int2IntOpenHashMap intMap = new Int2IntOpenHashMap();
                intMap.defaultReturnValue(-1);
                map = intMap;
                break;
            }
            case LONG: {
                Long2IntOpenHashMap longMap = new Long2IntOpenHashMap();
                longMap.defaultReturnValue(-1);
                map = longMap;
                break;
            }
            case FLOAT: {
                Float2IntOpenHashMap floatMap = new Float2IntOpenHashMap();
                floatMap.defaultReturnValue(-1);
                map = floatMap;
                break;
            }
            case DOUBLE: {
                Double2IntOpenHashMap doubleMap = new Double2IntOpenHashMap();
                doubleMap.defaultReturnValue(-1);
                map = doubleMap;
                break;
            }
            case STRING: {
                Object2IntOpenHashMap stringMap = new Object2IntOpenHashMap();
                stringMap.defaultReturnValue(-1);
                map = stringMap;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal data type for no-dictionary key generator: " + (Object)((Object)keyType));
            }
        }
        return map;
    }

    @Override
    public void generateKeysForBlock(@Nonnull TransformBlock transformBlock, @Nonnull int[][] groupKeys) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public int getCurrentGroupKeyUpperBound() {
        return this._groupKeyMap.size();
    }

    @Override
    public Iterator<GroupKeyGenerator.GroupKey> getUniqueGroupKeys() {
        return new GroupKeyIterator(this._groupKeyMap);
    }

    private int getKeyForValue(int value) {
        Int2IntMap map = (Int2IntMap)this._groupKeyMap;
        int groupId = map.get(value);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups;
            map.put(value, this._numGroups++);
        }
        return groupId;
    }

    private int getKeyForValue(long value) {
        Long2IntMap map = (Long2IntMap)this._groupKeyMap;
        int groupId = map.get(value);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups;
            map.put(value, this._numGroups++);
        }
        return groupId;
    }

    private int getKeyForValue(float value) {
        Float2IntMap map = (Float2IntMap)this._groupKeyMap;
        int groupId = map.get(value);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups;
            map.put(value, this._numGroups++);
        }
        return groupId;
    }

    private int getKeyForValue(double value) {
        Double2IntMap map = (Double2IntMap)this._groupKeyMap;
        int groupId = map.get(value);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups;
            map.put(value, this._numGroups++);
        }
        return groupId;
    }

    private int getKeyForValue(String value) {
        Object2IntMap map = (Object2IntMap)this._groupKeyMap;
        int groupId = map.getInt((Object)value);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups;
            map.put((Object)value, this._numGroups++);
        }
        return groupId;
    }

    class GroupKeyIterator
    implements Iterator<GroupKeyGenerator.GroupKey> {
        Iterator<Map.Entry<Object, Integer>> _iterator;
        GroupKeyGenerator.GroupKey _groupKey;

        public GroupKeyIterator(Map map) {
            this._iterator = map.entrySet().iterator();
            this._groupKey = new GroupKeyGenerator.GroupKey();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public GroupKeyGenerator.GroupKey next() {
            Map.Entry<Object, Integer> entry = this._iterator.next();
            this._groupKey._groupId = entry.getValue();
            this._groupKey._stringKey = entry.getKey().toString();
            return this._groupKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

