/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby;

import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;

public class ObjectGroupByResultHolder
implements GroupByResultHolder {
    private final int _maxCapacity;
    private int _resultHolderCapacity;
    private Object[] _resultArray;

    public ObjectGroupByResultHolder(int initialCapacity, int maxCapacity) {
        this._maxCapacity = maxCapacity;
        this._resultHolderCapacity = initialCapacity;
        this._resultArray = new Object[initialCapacity];
    }

    @Override
    public void ensureCapacity(int capacity) {
        Preconditions.checkArgument(capacity <= this._maxCapacity);
        if (capacity > this._resultHolderCapacity) {
            int copyLength = this._resultHolderCapacity;
            this._resultHolderCapacity = Math.max(this._resultHolderCapacity * 2, capacity);
            this._resultHolderCapacity = Math.min(this._resultHolderCapacity, this._maxCapacity);
            Object[] current = this._resultArray;
            this._resultArray = new Object[this._resultHolderCapacity];
            System.arraycopy(current, 0, this._resultArray, 0, copyLength);
        }
    }

    @Override
    public double getDoubleResult(int groupKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getResult(int groupKey) {
        if (groupKey == -1) {
            return null;
        }
        return (T)this._resultArray[groupKey];
    }

    @Override
    public void setValueForKey(int groupKey, double newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValueForKey(int groupKey, Object newValue) {
        if (groupKey != -1) {
            this._resultArray[groupKey] = newValue;
        }
    }
}

