/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.config;

import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.commons.configuration.ConfigurationException;
import org.apache.pinot.$internal.org.apache.pinot.core.query.config.QueryPlannerConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.query.config.SegmentPrunerConfig;

public class QueryExecutorConfig {
    public static final String QUERY_PRUNER = "pruner";
    public static final String QUERY_PLANNER = "queryPlanner";
    public static final String TIME_OUT = "timeout";
    private static final String[] REQUIRED_KEYS = new String[0];
    private Configuration _queryExecutorConfig = null;
    private SegmentPrunerConfig _segmentPrunerConfig;
    private QueryPlannerConfig _queryPlannerConfig;
    private final long _timeOutMs;

    public QueryExecutorConfig(Configuration config) throws ConfigurationException {
        this._queryExecutorConfig = config;
        this.checkRequiredKeys();
        this._segmentPrunerConfig = new SegmentPrunerConfig(this._queryExecutorConfig.subset(QUERY_PRUNER));
        this._queryPlannerConfig = new QueryPlannerConfig(this._queryExecutorConfig.subset(QUERY_PLANNER));
        this._timeOutMs = this._queryExecutorConfig.getLong(TIME_OUT, -1L);
    }

    private void checkRequiredKeys() throws ConfigurationException {
        for (String keyString : REQUIRED_KEYS) {
            if (this._queryExecutorConfig.containsKey(keyString)) continue;
            throw new ConfigurationException("Cannot find required key : " + keyString);
        }
    }

    public Configuration getConfig() {
        return this._queryExecutorConfig;
    }

    public SegmentPrunerConfig getPrunerConfig() {
        return this._segmentPrunerConfig;
    }

    public QueryPlannerConfig getQueryPlannerConfig() {
        return this._queryPlannerConfig;
    }

    public long getTimeOut() {
        return this._timeOutMs;
    }
}

