/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.commons.configuration.ConfigurationException;

public class SegmentPrunerConfig {
    private static String SEGMENT_PRUNER_CLASS = "class";
    private Configuration _segmentPrunerSetConfig;
    private static String[] REQUIRED_KEYS = new String[0];
    private List<String> _segmentPrunerClassNameList = new ArrayList<String>();
    private List<Configuration> _segmentPrunerConfigurationList = new ArrayList<Configuration>();

    public SegmentPrunerConfig(Configuration segmentPrunerConfig) throws ConfigurationException {
        String[] serviceClasses;
        this._segmentPrunerSetConfig = segmentPrunerConfig;
        this.checkRequiredKeys();
        for (String serviceClass : serviceClasses = this._segmentPrunerSetConfig.getStringArray(SEGMENT_PRUNER_CLASS)) {
            this._segmentPrunerClassNameList.add(serviceClass);
            this._segmentPrunerConfigurationList.add(this._segmentPrunerSetConfig.subset(serviceClass));
        }
    }

    private void checkRequiredKeys() throws ConfigurationException {
        for (String keyString : REQUIRED_KEYS) {
            if (this._segmentPrunerSetConfig.containsKey(keyString)) continue;
            throw new ConfigurationException("Cannot find required key : " + keyString);
        }
    }

    public String getSegmentPrunerName(int index) {
        return this._segmentPrunerClassNameList.get(index);
    }

    public Configuration getSegmentPrunerConfig(int index) {
        return this._segmentPrunerConfigurationList.get(index);
    }

    public int numberOfSegmentPruner() {
        return this._segmentPrunerConfigurationList.size();
    }
}

