/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.pruner;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.query.exception.BadQueryRequestException;
import org.apache.pinot.$internal.org.apache.pinot.core.query.pruner.SegmentPruner;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.ColumnMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.BloomFilterReader;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.utils.request.FilterQueryTree;

public abstract class AbstractSegmentPruner
implements SegmentPruner {
    public abstract boolean pruneSegment(FilterQueryTree var1, Map<String, ColumnMetadata> var2, Map<String, BloomFilterReader> var3);

    protected boolean pruneNonLeaf(@Nonnull FilterQueryTree filterQueryTree, @Nonnull Map<String, ColumnMetadata> columnMetadataMap, Map<String, BloomFilterReader> bloomFilterMap) {
        List<FilterQueryTree> children = filterQueryTree.getChildren();
        if (children.isEmpty()) {
            return false;
        }
        FilterOperator filterOperator = filterQueryTree.getOperator();
        switch (filterOperator) {
            case AND: {
                for (FilterQueryTree child : children) {
                    if (!this.pruneSegment(child, columnMetadataMap, bloomFilterMap)) continue;
                    return true;
                }
                return false;
            }
            case OR: {
                for (FilterQueryTree child : children) {
                    if (this.pruneSegment(child, columnMetadataMap, bloomFilterMap)) continue;
                    return false;
                }
                return true;
            }
        }
        throw new IllegalStateException("Unsupported filter operator: " + filterOperator);
    }

    protected static Comparable getValue(@Nonnull String input, @Nonnull FieldSpec.DataType dataType) {
        try {
            switch (dataType) {
                case INT: {
                    return Integer.valueOf(input);
                }
                case LONG: {
                    return Long.valueOf(input);
                }
                case FLOAT: {
                    return Float.valueOf(input);
                }
                case DOUBLE: {
                    return Double.valueOf(input);
                }
                case STRING: {
                    return input;
                }
            }
            throw new IllegalStateException("Unsupported data type: " + (Object)((Object)dataType));
        }
        catch (NumberFormatException e) {
            throw new BadQueryRequestException(e);
        }
    }
}

