/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.pruner;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.pinot.core.common.predicate.RangePredicate;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.query.pruner.AbstractSegmentPruner;
import org.apache.pinot.$internal.org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.ColumnMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.BloomFilterReader;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.utils.request.FilterQueryTree;

public class ColumnValueSegmentPruner
extends AbstractSegmentPruner {
    @Override
    public void init(Configuration config) {
    }

    @Override
    public boolean prune(@Nonnull IndexSegment segment, @Nonnull ServerQueryRequest queryRequest) {
        FilterQueryTree filterQueryTree = queryRequest.getFilterQueryTree();
        if (filterQueryTree == null) {
            return false;
        }
        Map<String, ColumnMetadata> columnMetadataMap = ((SegmentMetadataImpl)segment.getSegmentMetadata()).getColumnMetadataMap();
        HashMap<String, BloomFilterReader> bloomFilterMap = new HashMap<String, BloomFilterReader>();
        if (columnMetadataMap != null) {
            for (String column : columnMetadataMap.keySet()) {
                BloomFilterReader bloomFilterReader = segment.getDataSource(column).getBloomFilter();
                if (bloomFilterReader == null) continue;
                bloomFilterMap.put(column, bloomFilterReader);
            }
        }
        return columnMetadataMap != null && this.pruneSegment(filterQueryTree, columnMetadataMap, bloomFilterMap);
    }

    public String toString() {
        return "ColumnValueSegmentPruner";
    }

    @Override
    public boolean pruneSegment(@Nonnull FilterQueryTree filterQueryTree, @Nonnull Map<String, ColumnMetadata> columnMetadataMap, Map<String, BloomFilterReader> bloomFilterMap) {
        FilterOperator filterOperator = filterQueryTree.getOperator();
        List<FilterQueryTree> children = filterQueryTree.getChildren();
        if (children == null || children.isEmpty()) {
            if (filterOperator != FilterOperator.EQUALITY && filterOperator != FilterOperator.RANGE) {
                return false;
            }
            String column = filterQueryTree.getColumn();
            ColumnMetadata columnMetadata = columnMetadataMap.get(column);
            if (columnMetadata == null) {
                return true;
            }
            Comparable minValue = columnMetadata.getMinValue();
            Comparable maxValue = columnMetadata.getMaxValue();
            if (filterOperator == FilterOperator.EQUALITY) {
                boolean pruneSegment = false;
                FieldSpec.DataType dataType = columnMetadata.getDataType();
                Comparable value = ColumnValueSegmentPruner.getValue(filterQueryTree.getValue().get(0), dataType);
                if (minValue != null && maxValue != null) {
                    boolean bl = pruneSegment = value.compareTo(minValue) < 0 || value.compareTo(maxValue) > 0;
                }
                if (!pruneSegment && bloomFilterMap.containsKey(column)) {
                    BloomFilterReader bloomFilterReader = bloomFilterMap.get(column);
                    pruneSegment = !bloomFilterReader.mightContain(value);
                }
                return pruneSegment;
            }
            FieldSpec.DataType dataType = columnMetadata.getDataType();
            RangePredicate rangePredicate = new RangePredicate(null, filterQueryTree.getValue());
            String lowerBoundary = rangePredicate.getLowerBoundary();
            boolean includeLowerBoundary = rangePredicate.includeLowerBoundary();
            Comparable lowerBoundaryValue = null;
            if (!lowerBoundary.equals("*")) {
                lowerBoundaryValue = ColumnValueSegmentPruner.getValue(lowerBoundary, dataType);
            }
            String upperBoundary = rangePredicate.getUpperBoundary();
            boolean includeUpperBoundary = rangePredicate.includeUpperBoundary();
            Comparable upperBoundaryValue = null;
            if (!upperBoundary.equals("*")) {
                upperBoundaryValue = ColumnValueSegmentPruner.getValue(upperBoundary, dataType);
            }
            if (lowerBoundaryValue != null && upperBoundaryValue != null && (includeLowerBoundary && includeUpperBoundary ? lowerBoundaryValue.compareTo(upperBoundaryValue) > 0 : lowerBoundaryValue.compareTo(upperBoundaryValue) >= 0)) {
                return true;
            }
            if (minValue == null || maxValue == null) {
                return false;
            }
            if (lowerBoundaryValue != null && (includeLowerBoundary ? lowerBoundaryValue.compareTo(maxValue) > 0 : lowerBoundaryValue.compareTo(maxValue) >= 0)) {
                return true;
            }
            return upperBoundaryValue != null && (includeUpperBoundary ? upperBoundaryValue.compareTo(minValue) < 0 : upperBoundaryValue.compareTo(minValue) <= 0);
        }
        return this.pruneNonLeaf(filterQueryTree, columnMetadataMap, bloomFilterMap);
    }
}

