/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.pruner;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.pinot.core.query.pruner.SegmentPruner;
import org.apache.pinot.$internal.org.apache.pinot.core.query.pruner.ValidSegmentPruner;

public class SegmentPrunerProvider {
    private static final Map<String, Class<? extends SegmentPruner>> PRUNER_MAP = new HashMap<String, Class<? extends SegmentPruner>>();

    private SegmentPrunerProvider() {
    }

    public static SegmentPruner getSegmentPruner(String prunerClassName, Configuration segmentPrunerConfig) {
        try {
            Class<? extends SegmentPruner> cls = PRUNER_MAP.get(prunerClassName.toLowerCase());
            if (cls != null) {
                SegmentPruner segmentPruner = cls.newInstance();
                segmentPruner.init(segmentPrunerConfig);
                return segmentPruner;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Not support SegmentPruner type with - " + prunerClassName, ex);
        }
        throw new UnsupportedOperationException("No SegmentPruner type with - " + prunerClassName);
    }

    static {
        PRUNER_MAP.put("columnvaluesegmentpruner", .ColumnValueSegmentPruner.class);
        PRUNER_MAP.put("dataschemasegmentpruner", .DataSchemaSegmentPruner.class);
        PRUNER_MAP.put("validsegmentpruner", ValidSegmentPruner.class);
        PRUNER_MAP.put("partitionsegmentpruner", .PartitionSegmentPruner.class);
    }
}

