/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.pruner;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.query.config.SegmentPrunerConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.query.pruner.SegmentPruner;
import org.apache.pinot.$internal.org.apache.pinot.core.query.pruner.SegmentPrunerProvider;
import org.apache.pinot.$internal.org.apache.pinot.core.query.request.ServerQueryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPrunerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentPrunerService.class);
    private final List<SegmentPruner> _segmentPruners;

    public SegmentPrunerService(SegmentPrunerConfig config) {
        int numPruners = config.numberOfSegmentPruner();
        this._segmentPruners = new ArrayList<SegmentPruner>(numPruners);
        for (int i = 0; i < numPruners; ++i) {
            LOGGER.info("Adding segment pruner: " + config.getSegmentPrunerName(i));
            this._segmentPruners.add(SegmentPrunerProvider.getSegmentPruner(config.getSegmentPrunerName(i), config.getSegmentPrunerConfig(i)));
        }
    }

    public boolean prune(IndexSegment segment, ServerQueryRequest queryRequest) {
        for (SegmentPruner segmentPruner : this._segmentPruners) {
            if (!segmentPruner.prune(segment, queryRequest)) continue;
            LOGGER.debug("Pruned segment: {}", (Object)segment.getSegmentName());
            return true;
        }
        return false;
    }
}

