/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.reduce;

import org.apache.pinot.$internal.org.apache.pinot.core.query.reduce.ComparisonFunction;
import org.apache.pinot.common.request.AggregationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreaterThanComparison
extends ComparisonFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(GreaterThanComparison.class);
    private double _rightValue;

    public GreaterThanComparison(String rightValue, AggregationInfo aggregationInfo) {
        super(aggregationInfo);
        try {
            this._rightValue = Double.parseDouble(rightValue);
        }
        catch (Exception e) {
            LOGGER.info("Exception in creating HAVING clause GREATER predicate", (Throwable)e);
        }
    }

    @Override
    public boolean isComparisonValid(String aggResult) {
        try {
            double leftValue = Double.parseDouble(aggResult);
            return leftValue > this._rightValue;
        }
        catch (Exception e) {
            LOGGER.info("Exception in applying HAVING clause GREATER predicate", (Throwable)e);
            return false;
        }
    }

    public double getRightValue() {
        return this._rightValue;
    }
}

