/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.reduce;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.pinot.core.query.reduce.BetweenComparison;
import org.apache.pinot.$internal.org.apache.pinot.core.query.reduce.ComparisonFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.reduce.EqualComparison;
import org.apache.pinot.$internal.org.apache.pinot.core.query.reduce.GreaterEqualComparison;
import org.apache.pinot.$internal.org.apache.pinot.core.query.reduce.GreaterThanComparison;
import org.apache.pinot.$internal.org.apache.pinot.core.query.reduce.InAndNotInComparison;
import org.apache.pinot.$internal.org.apache.pinot.core.query.reduce.LessEqualComparison;
import org.apache.pinot.$internal.org.apache.pinot.core.query.reduce.LessThanComparison;
import org.apache.pinot.$internal.org.apache.pinot.core.query.reduce.NotEqualComparison;
import org.apache.pinot.common.request.AggregationInfo;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.request.HavingFilterQuery;
import org.apache.pinot.common.request.HavingFilterQueryMap;

public class HavingClauseComparisonTree {
    private FilterOperator _filterOperator;
    private ComparisonFunction _comparisonFunction;
    private List<HavingClauseComparisonTree> _subComparisonTree;

    public HavingClauseComparisonTree(FilterOperator filterOperator, ComparisonFunction comparisonFunction, List<HavingClauseComparisonTree> subComparisonTree) {
        this._filterOperator = filterOperator;
        this._comparisonFunction = comparisonFunction;
        this._subComparisonTree = subComparisonTree;
    }

    public static HavingClauseComparisonTree buildHavingClauseComparisonTree(HavingFilterQuery havingFilterQuery, HavingFilterQueryMap havingFilterQueryMap) {
        if (havingFilterQuery.getNestedFilterQueryIdsSize() == 0) {
            return new HavingClauseComparisonTree(null, HavingClauseComparisonTree.buildComparisonFunction(havingFilterQuery), null);
        }
        ArrayList<HavingClauseComparisonTree> subComparisonTree = new ArrayList<HavingClauseComparisonTree>();
        Iterator<Integer> iterator = havingFilterQuery.getNestedFilterQueryIdsIterator();
        while (iterator.hasNext()) {
            subComparisonTree.add(HavingClauseComparisonTree.buildHavingClauseComparisonTree(havingFilterQueryMap.getFilterQueryMap().get(iterator.next()), havingFilterQueryMap));
        }
        return new HavingClauseComparisonTree(havingFilterQuery.getOperator(), null, subComparisonTree);
    }

    private static ComparisonFunction buildComparisonFunction(HavingFilterQuery havingFilterQuery) {
        FilterOperator operator = havingFilterQuery.getOperator();
        ComparisonFunction comparisonFunction = null;
        if (operator == FilterOperator.EQUALITY) {
            comparisonFunction = new EqualComparison(havingFilterQuery.getValue().get(0), havingFilterQuery.getAggregationInfo());
        } else if (operator == FilterOperator.NOT) {
            comparisonFunction = new NotEqualComparison(havingFilterQuery.getValue().get(0), havingFilterQuery.getAggregationInfo());
        } else if (operator == FilterOperator.RANGE) {
            String value = havingFilterQuery.getValue().get(0);
            comparisonFunction = HavingClauseComparisonTree.havingRangeStringToComparisonFunction(value, havingFilterQuery.getAggregationInfo());
        } else if (operator == FilterOperator.NOT_IN) {
            comparisonFunction = new InAndNotInComparison(havingFilterQuery.getValue().get(0), true, havingFilterQuery.getAggregationInfo());
        } else if (operator == FilterOperator.IN) {
            comparisonFunction = new InAndNotInComparison(havingFilterQuery.getValue().get(0), false, havingFilterQuery.getAggregationInfo());
        } else {
            throw new IllegalStateException("The " + operator.toString() + " operator is not supported for HAVING clause");
        }
        return comparisonFunction;
    }

    private static ComparisonFunction havingRangeStringToComparisonFunction(String rangeString, AggregationInfo aggregationInfo) {
        ComparisonFunction comparisonFunction = null;
        if (rangeString.matches("\\(\\*\\t\\t[-]?[0-9].*\\)")) {
            String[] tokens = rangeString.split("\\t|\\)");
            comparisonFunction = new LessThanComparison(tokens[2], aggregationInfo);
        } else if (rangeString.matches("\\(\\*\\t\\t[-]?[0-9].*\\]")) {
            String[] tokens = rangeString.split("\\t|\\]");
            comparisonFunction = new LessEqualComparison(tokens[2], aggregationInfo);
        } else if (rangeString.matches("\\([-]?[0-9].*\\t\\t\\*\\)")) {
            String[] tokens = rangeString.split("\\(|\\t");
            comparisonFunction = new GreaterThanComparison(tokens[1], aggregationInfo);
        } else if (rangeString.matches("\\[[-]?[0-9].*\\t\\t\\*\\)")) {
            String[] tokens = rangeString.split("\\[|\\t");
            comparisonFunction = new GreaterEqualComparison(tokens[1], aggregationInfo);
        } else if (rangeString.matches("\\[[-]?[0-9].*\\t\\t[-]?[0-9].*\\]")) {
            String[] tokens = rangeString.split("\\[|\\t\\t|\\]");
            comparisonFunction = new BetweenComparison(tokens[1], tokens[2], aggregationInfo);
        }
        return comparisonFunction;
    }

    public FilterOperator getFilterOperator() {
        return this._filterOperator;
    }

    public ComparisonFunction getComparisonFunction() {
        return this._comparisonFunction;
    }

    public List<HavingClauseComparisonTree> getSubComparisonTree() {
        return this._subComparisonTree;
    }

    public boolean isThisGroupPassPredicates(Map<String, Comparable> singleGroupAggResults) {
        if (this._subComparisonTree == null || this._subComparisonTree.isEmpty()) {
            if (singleGroupAggResults.get(this._comparisonFunction.getFunctionExpression()) == null) {
                throw new IllegalStateException("All the columns in the HAVING clause expect to be in the input;" + this._comparisonFunction.getFunctionExpression() + " is missing");
            }
            return this._comparisonFunction.isComparisonValid(singleGroupAggResults.get(this._comparisonFunction.getFunctionExpression()).toString());
        }
        if (this._filterOperator.equals(FilterOperator.AND)) {
            for (int i = 0; i < this._subComparisonTree.size(); ++i) {
                if (this._subComparisonTree.get(i).isThisGroupPassPredicates(singleGroupAggResults)) continue;
                return false;
            }
            return true;
        }
        if (this._filterOperator.equals(FilterOperator.OR)) {
            for (int i = 0; i < this._subComparisonTree.size(); ++i) {
                if (!this._subComparisonTree.get(i).isThisGroupPassPredicates(singleGroupAggResults)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

