/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.reduce;

import org.apache.pinot.$internal.org.apache.pinot.core.query.reduce.ComparisonFunction;
import org.apache.pinot.common.request.AggregationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InAndNotInComparison
extends ComparisonFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(InAndNotInComparison.class);
    private double[] _values;
    private boolean _isItNotIn;

    public InAndNotInComparison(String values, boolean isItNotIn, AggregationInfo aggregationInfo) {
        super(aggregationInfo);
        String[] splitedValues = values.split("\\t\\t");
        int size = splitedValues.length;
        this._values = new double[size];
        for (int i = 0; i < size; ++i) {
            try {
                this._values[i] = Double.parseDouble(splitedValues[i]);
                continue;
            }
            catch (Exception e) {
                LOGGER.info("Exception in creating HAVING clause IN/NOT-IN predicate", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isComparisonValid(String aggResult) {
        try {
            int i;
            double baseValue = Double.parseDouble(aggResult);
            int size = this._values.length;
            for (i = 0; i < size && baseValue != this._values[i]; ++i) {
            }
            if (!this._isItNotIn) {
                return i < size;
            }
            return i >= size;
        }
        catch (Exception e) {
            LOGGER.info("Exception in applying HAVING clause IN/NOT-IN predicate", (Throwable)e);
            return false;
        }
    }

    public double[] getValues() {
        return this._values;
    }
}

