/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.OutOfCapacityException;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.SchedulerGroup;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.SchedulerGroupFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.SchedulerGroupMapper;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.SchedulerPriorityQueue;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.SchedulerQueryContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.resources.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLevelPriorityQueue
implements SchedulerPriorityQueue {
    private static Logger LOGGER = LoggerFactory.getLogger(MultiLevelPriorityQueue.class);
    public static final String QUERY_DEADLINE_SECONDS_KEY = "query_deadline_seconds";
    public static final String MAX_PENDING_PER_GROUP_KEY = "max_pending_per_group";
    public static final String QUEUE_WAKEUP_MICROS = "queue_wakeup_micros";
    private static final int DEFAULT_WAKEUP_MICROS = 1000;
    private static int wakeUpTimeMicros = 1000;
    private final int maxPendingPerGroup;
    private final Map<String, SchedulerGroup> schedulerGroups = new HashMap<String, SchedulerGroup>();
    private final Lock queueLock = new ReentrantLock();
    private final Condition queryReaderCondition = this.queueLock.newCondition();
    private final ResourceManager resourceManager;
    private final SchedulerGroupMapper groupSelector;
    private final int queryDeadlineMillis;
    private final SchedulerGroupFactory groupFactory;
    private final Configuration config;

    public MultiLevelPriorityQueue(@Nonnull Configuration config, @Nonnull ResourceManager resourceManager, @Nonnull SchedulerGroupFactory groupFactory, @Nonnull SchedulerGroupMapper groupMapper) {
        Preconditions.checkNotNull(config);
        Preconditions.checkNotNull(resourceManager);
        Preconditions.checkNotNull(groupFactory);
        Preconditions.checkNotNull(groupMapper);
        this.queryDeadlineMillis = config.getInt(QUERY_DEADLINE_SECONDS_KEY, 30) * 1000;
        wakeUpTimeMicros = config.getInt(QUEUE_WAKEUP_MICROS, 1000);
        this.maxPendingPerGroup = config.getInt(MAX_PENDING_PER_GROUP_KEY, 10);
        this.config = config;
        this.resourceManager = resourceManager;
        this.groupFactory = groupFactory;
        this.groupSelector = groupMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(@Nonnull SchedulerQueryContext query) throws OutOfCapacityException {
        Preconditions.checkNotNull(query);
        this.queueLock.lock();
        String groupName = this.groupSelector.getSchedulerGroupName(query);
        try {
            SchedulerGroup groupContext = this.getOrCreateGroupContext(groupName);
            this.checkGroupHasCapacity(groupContext);
            query.setSchedulerGroupContext(groupContext);
            groupContext.addLast(query);
            this.queryReaderCondition.signal();
        }
        finally {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public SchedulerQueryContext take() {
        this.queueLock.lock();
        try {
            SchedulerQueryContext schedulerQueryContext;
            while ((schedulerQueryContext = this.takeNextInternal()) == null) {
                try {
                    this.queryReaderCondition.await(wakeUpTimeMicros, TimeUnit.MICROSECONDS);
                }
                catch (InterruptedException e) {
                    SchedulerQueryContext schedulerQueryContext2 = null;
                    this.queueLock.unlock();
                    return schedulerQueryContext2;
                }
            }
            SchedulerQueryContext schedulerQueryContext3 = schedulerQueryContext;
            return schedulerQueryContext3;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public List<SchedulerQueryContext> drain() {
        ArrayList<SchedulerQueryContext> pending = new ArrayList<SchedulerQueryContext>();
        this.queueLock.lock();
        try {
            for (Map.Entry<String, SchedulerGroup> groupEntry : this.schedulerGroups.entrySet()) {
                SchedulerGroup group = groupEntry.getValue();
                while (!group.isEmpty()) {
                    pending.add(group.removeFirst());
                }
            }
        }
        finally {
            this.queueLock.unlock();
        }
        return pending;
    }

    private SchedulerQueryContext takeNextInternal() {
        SchedulerGroup currentWinnerGroup = null;
        long startTime = System.nanoTime();
        StringBuilder sb = new StringBuilder("SchedulerInfo:");
        long deadlineEpochMillis = this.currentTimeMillis() - (long)this.queryDeadlineMillis;
        for (Map.Entry<String, SchedulerGroup> groupInfoEntry : this.schedulerGroups.entrySet()) {
            SchedulerGroup group = groupInfoEntry.getValue();
            if (LOGGER.isDebugEnabled()) {
                sb.append(group.toString());
            }
            group.trimExpired(deadlineEpochMillis);
            if (group.isEmpty() || !this.resourceManager.canSchedule(group)) continue;
            if (currentWinnerGroup == null) {
                currentWinnerGroup = group;
                continue;
            }
            int comparison = group.compareTo(currentWinnerGroup);
            if (comparison < 0) {
                if (currentWinnerGroup.totalReservedThreads() <= this.resourceManager.getTableThreadsSoftLimit() || group.totalReservedThreads() >= this.resourceManager.getTableThreadsSoftLimit()) continue;
                currentWinnerGroup = group;
                continue;
            }
            if (comparison < 0 || group.totalReservedThreads() >= this.resourceManager.getTableThreadsSoftLimit() && group.totalReservedThreads() >= currentWinnerGroup.totalReservedThreads()) continue;
            currentWinnerGroup = group;
        }
        SchedulerQueryContext query = null;
        if (currentWinnerGroup != null) {
            ServerQueryRequest queryRequest = currentWinnerGroup.peekFirst().getQueryRequest();
            if (LOGGER.isDebugEnabled()) {
                sb.append(String.format(" Winner: %s: [%d,%d,%d,%d]", currentWinnerGroup.name(), queryRequest.getTimerContext().getQueryArrivalTimeMs(), queryRequest.getRequestId(), queryRequest.getSegmentsToQuery().size(), startTime));
            }
            query = currentWinnerGroup.removeFirst();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sb.toString());
        }
        return query;
    }

    private void checkGroupHasCapacity(SchedulerGroup groupContext) throws OutOfCapacityException {
        if (groupContext.numPending() >= this.maxPendingPerGroup && groupContext.totalReservedThreads() >= this.resourceManager.getTableThreadsHardLimit()) {
            throw new OutOfCapacityException(String.format("SchedulerGroup %s is out of capacity. numPending: %d, maxPending: %d, reservedThreads: %d threadsHardLimit: %d", groupContext.name(), groupContext.numPending(), this.maxPendingPerGroup, groupContext.totalReservedThreads(), this.resourceManager.getTableThreadsHardLimit()));
        }
    }

    private SchedulerGroup getOrCreateGroupContext(String groupName) {
        SchedulerGroup groupContext = this.schedulerGroups.get(groupName);
        if (groupContext == null) {
            groupContext = this.groupFactory.create(this.config, groupName);
            this.schedulerGroups.put(groupName, groupContext);
        }
        return groupContext;
    }

    private long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @VisibleForTesting
    long getWakeupTimeMicros() {
        return wakeUpTimeMicros;
    }
}

