/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.LongAccumulator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.com.google.common.util.concurrent.Futures;
import org.apache.pinot.$internal.com.google.common.util.concurrent.ListenableFuture;
import org.apache.pinot.$internal.com.google.common.util.concurrent.ListenableFutureTask;
import org.apache.pinot.$internal.org.apache.pinot.core.common.datatable.DataTableImplV2;
import org.apache.pinot.$internal.org.apache.pinot.core.query.executor.QueryExecutor;
import org.apache.pinot.$internal.org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.$internal.org.apache.pinot.core.query.request.context.TimerContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.resources.ResourceManager;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.metrics.ServerQueryPhase;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryScheduler.class);
    private static final String INVALID_NUM_SCANNED = "-1";
    private static final String INVALID_SEGMENTS_COUNT = "-1";
    protected final ServerMetrics serverMetrics;
    protected final QueryExecutor queryExecutor;
    protected final ResourceManager resourceManager;
    protected final LongAccumulator latestQueryTime;
    protected volatile boolean isRunning = false;

    public QueryScheduler(@Nonnull QueryExecutor queryExecutor, @Nonnull ResourceManager resourceManager, @Nonnull ServerMetrics serverMetrics, @Nonnull LongAccumulator latestQueryTime) {
        Preconditions.checkNotNull(queryExecutor);
        Preconditions.checkNotNull(resourceManager);
        Preconditions.checkNotNull(serverMetrics);
        this.serverMetrics = serverMetrics;
        this.resourceManager = resourceManager;
        this.queryExecutor = queryExecutor;
        this.latestQueryTime = latestQueryTime;
    }

    @Nonnull
    public abstract ListenableFuture<byte[]> submit(@Nonnull ServerQueryRequest var1);

    public abstract String name();

    public void start() {
        this.isRunning = true;
    }

    public void stop() {
        this.isRunning = false;
    }

    protected ListenableFutureTask<byte[]> createQueryFutureTask(@Nonnull ServerQueryRequest queryRequest, @Nonnull ExecutorService executorService) {
        return ListenableFutureTask.create(() -> this.processQueryAndSerialize(queryRequest, executorService));
    }

    @Nullable
    protected byte[] processQueryAndSerialize(@Nonnull ServerQueryRequest queryRequest, @Nonnull ExecutorService executorService) {
        DataTable dataTable;
        this.latestQueryTime.accumulate(System.currentTimeMillis());
        try {
            dataTable = this.queryExecutor.processQuery(queryRequest, executorService);
        }
        catch (Exception e) {
            LOGGER.error("Encountered exception while processing requestId {} from broker {}", new Object[]{queryRequest.getRequestId(), queryRequest.getBrokerId(), e});
            this.serverMetrics.addMeteredGlobalValue(ServerMeter.UNCAUGHT_EXCEPTIONS, 1L);
            dataTable = new DataTableImplV2();
            dataTable.addException(QueryException.getException(QueryException.INTERNAL_ERROR, e));
        }
        long requestId = queryRequest.getRequestId();
        Map<String, String> dataTableMetadata = dataTable.getMetadata();
        dataTableMetadata.put("requestId", Long.toString(requestId));
        byte[] responseData = this.serializeDataTable(queryRequest, dataTable);
        String tableNameWithType = queryRequest.getTableNameWithType();
        long numDocsScanned = Long.parseLong(dataTableMetadata.getOrDefault("numDocsScanned", "-1"));
        long numEntriesScannedInFilter = Long.parseLong(dataTableMetadata.getOrDefault("numEntriesScannedInFilter", "-1"));
        long numEntriesScannedPostFilter = Long.parseLong(dataTableMetadata.getOrDefault("numSegmentsQueried", "-1"));
        long numSegmentsProcessed = Long.parseLong(dataTableMetadata.getOrDefault("numSegmentsProcessed", "-1"));
        long numSegmentsMatched = Long.parseLong(dataTableMetadata.getOrDefault("numSegmentsMatched", "-1"));
        if (numDocsScanned > 0L) {
            this.serverMetrics.addMeteredTableValue(tableNameWithType, ServerMeter.NUM_DOCS_SCANNED, numDocsScanned);
        }
        if (numEntriesScannedInFilter > 0L) {
            this.serverMetrics.addMeteredTableValue(tableNameWithType, ServerMeter.NUM_ENTRIES_SCANNED_IN_FILTER, numEntriesScannedInFilter);
        }
        if (numEntriesScannedPostFilter > 0L) {
            this.serverMetrics.addMeteredTableValue(tableNameWithType, ServerMeter.NUM_ENTRIES_SCANNED_POST_FILTER, numEntriesScannedPostFilter);
        }
        TimerContext timerContext = queryRequest.getTimerContext();
        int numSegmentsQueried = queryRequest.getSegmentsToQuery().size();
        LOGGER.info("Processed requestId={},table={},Segments(Queried/processed/matched)={}/{}/{},totalExecMs={},totalTimeMs={},broker={},numDocsScanned={},scanInFilter={},scanPostFilter={},sched={}", new Object[]{requestId, tableNameWithType, numSegmentsQueried, numSegmentsProcessed, numSegmentsMatched, timerContext.getPhaseDurationMs(ServerQueryPhase.QUERY_PROCESSING), timerContext.getPhaseDurationMs(ServerQueryPhase.TOTAL_QUERY_TIME), queryRequest.getBrokerId(), numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, this.name()});
        this.serverMetrics.addMeteredTableValue(tableNameWithType, ServerMeter.NUM_SEGMENTS_QUERIED, numSegmentsQueried);
        this.serverMetrics.addMeteredTableValue(tableNameWithType, ServerMeter.NUM_SEGMENTS_PROCESSED, numSegmentsProcessed);
        this.serverMetrics.addMeteredTableValue(tableNameWithType, ServerMeter.NUM_SEGMENTS_MATCHED, numSegmentsMatched);
        return responseData;
    }

    @Nullable
    private byte[] serializeDataTable(@Nonnull ServerQueryRequest queryRequest, @Nonnull DataTable dataTable) {
        TimerContext timerContext = queryRequest.getTimerContext();
        TimerContext.Timer responseSerializationTimer = timerContext.startNewPhaseTimer(ServerQueryPhase.RESPONSE_SERIALIZATION);
        byte[] responseByte = null;
        try {
            responseByte = dataTable.toBytes();
        }
        catch (Exception e) {
            this.serverMetrics.addMeteredGlobalValue(ServerMeter.RESPONSE_SERIALIZATION_EXCEPTIONS, 1L);
            LOGGER.error("Caught exception while serializing response for requestId: {}, brokerId: {}", new Object[]{queryRequest.getRequestId(), queryRequest.getBrokerId(), e});
        }
        responseSerializationTimer.stopAndRecord();
        timerContext.startNewPhaseTimer(ServerQueryPhase.TOTAL_QUERY_TIME, timerContext.getQueryArrivalTimeMs()).stopAndRecord();
        return responseByte;
    }

    protected ListenableFuture<byte[]> immediateErrorResponse(ServerQueryRequest queryRequest, ProcessingException error) {
        DataTableImplV2 result = new DataTableImplV2();
        result.addException(error);
        return Futures.immediateFuture(this.serializeDataTable(queryRequest, result));
    }
}

