/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler;

import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.LongAccumulator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.pinot.core.query.executor.QueryExecutor;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.QueryScheduler;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.fcfs.BoundedFCFSScheduler;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.fcfs.FCFSQueryScheduler;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.tokenbucket.TokenPriorityScheduler;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySchedulerFactory {
    private static final String FCFS_ALGORITHM = "fcfs";
    private static final String DEFAULT_QUERY_SCHEDULER_ALGORITHM = "fcfs";
    public static final String TOKEN_BUCKET_ALGORITHM = "tokenbucket";
    public static final String BOUNDED_FCFS_ALGORITHM = "bounded_fcfs";
    public static final String ALGORITHM_NAME_CONFIG_KEY = "name";
    private static Logger LOGGER = LoggerFactory.getLogger(QuerySchedulerFactory.class);

    @Nonnull
    public static QueryScheduler create(@Nonnull Configuration schedulerConfig, @Nonnull QueryExecutor queryExecutor, ServerMetrics serverMetrics, @Nonnull LongAccumulator latestQueryTime) {
        Preconditions.checkNotNull(schedulerConfig);
        Preconditions.checkNotNull(queryExecutor);
        String schedulerName = schedulerConfig.getString(ALGORITHM_NAME_CONFIG_KEY, "fcfs").toLowerCase();
        if (schedulerName.equals("fcfs")) {
            LOGGER.info("Using FCFS query scheduler");
            return new FCFSQueryScheduler(schedulerConfig, queryExecutor, serverMetrics, latestQueryTime);
        }
        if (schedulerName.equals(TOKEN_BUCKET_ALGORITHM)) {
            LOGGER.info("Using Priority Token Bucket scheduler");
            return TokenPriorityScheduler.create(schedulerConfig, queryExecutor, serverMetrics, latestQueryTime);
        }
        if (schedulerName.equals(BOUNDED_FCFS_ALGORITHM)) {
            return BoundedFCFSScheduler.create(schedulerConfig, queryExecutor, serverMetrics, latestQueryTime);
        }
        QueryScheduler scheduler = QuerySchedulerFactory.getQuerySchedulerByClassName(schedulerName, schedulerConfig, queryExecutor);
        if (scheduler != null) {
            return scheduler;
        }
        LOGGER.warn("Scheduler {} not found. Using default FCFS query scheduler", (Object)schedulerName);
        return new FCFSQueryScheduler(schedulerConfig, queryExecutor, serverMetrics, latestQueryTime);
    }

    @Nullable
    private static QueryScheduler getQuerySchedulerByClassName(String className, Configuration schedulerConfig, QueryExecutor queryExecutor) {
        try {
            Constructor<?> constructor = Class.forName(className).getDeclaredConstructor(Configuration.class, QueryExecutor.class);
            constructor.setAccessible(true);
            return (QueryScheduler)constructor.newInstance(schedulerConfig, queryExecutor);
        }
        catch (Exception e) {
            LOGGER.error("Failed to instantiate scheduler class by name: {}", (Object)className, (Object)e);
            return null;
        }
    }
}

