/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.resources;

import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.SchedulerGroupAccountant;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.resources.QueryExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundedAccountingExecutor
extends QueryExecutorService {
    private static Logger LOGGER = LoggerFactory.getLogger(BoundedAccountingExecutor.class);
    private final Executor delegateExecutor;
    private final int bounds;
    private Semaphore semaphore;
    private final SchedulerGroupAccountant accountant;

    public BoundedAccountingExecutor(@Nonnull Executor s, int bounds, @Nonnull SchedulerGroupAccountant accountant) {
        Preconditions.checkNotNull(s);
        Preconditions.checkNotNull(accountant);
        Preconditions.checkArgument(bounds > 0);
        this.delegateExecutor = s;
        this.bounds = bounds;
        this.semaphore = new Semaphore(bounds);
        this.accountant = accountant;
    }

    @Override
    public void execute(Runnable command) {
        this.delegateExecutor.execute(this.toAccountingRunnable(command));
    }

    @Override
    public void releaseWorkers() {
        this.accountant.releasedReservedThreads(this.bounds);
    }

    private QueryAccountingRunnable toAccountingRunnable(Runnable runnable) {
        this.acquirePermits(1);
        return new QueryAccountingRunnable(runnable, this.semaphore, this.accountant);
    }

    private void acquirePermits(int permits) {
        try {
            this.semaphore.acquire(permits);
        }
        catch (InterruptedException e) {
            LOGGER.error("Thread interrupted while waiting for semaphore", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private class QueryAccountingRunnable
    implements Runnable {
        private final Runnable runnable;
        private final Semaphore semaphore;
        private final SchedulerGroupAccountant accountant;

        QueryAccountingRunnable(Runnable r, Semaphore semaphore, SchedulerGroupAccountant accountant) {
            this.runnable = r;
            this.semaphore = semaphore;
            this.accountant = accountant;
        }

        @Override
        public void run() {
            try {
                if (this.accountant != null) {
                    this.accountant.incrementThreads();
                }
                this.runnable.run();
            }
            finally {
                if (this.accountant != null) {
                    this.accountant.decrementThreads();
                }
                this.semaphore.release();
            }
        }
    }
}

