/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.resources;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.pinot.;
import org.apache.pinot.$internal.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.$internal.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.pinot.$internal.com.google.common.util.concurrent.MoreExecutors;
import org.apache.pinot.$internal.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.SchedulerGroupAccountant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceManager {
    private static final Logger LOGGER;
    public static final String QUERY_RUNNER_CONFIG_KEY = "query_runner_threads";
    public static final String QUERY_WORKER_CONFIG_KEY = "query_worker_threads";
    public static final int DEFAULT_QUERY_RUNNER_THREADS;
    public static final int DEFAULT_QUERY_WORKER_THREADS;
    protected static final int QUERY_RUNNER_THREAD_PRIORITY = 7;
    protected final ListeningExecutorService queryRunners;
    protected final ListeningExecutorService queryWorkers;
    protected final int numQueryRunnerThreads;
    protected final int numQueryWorkerThreads;

    public ResourceManager(Configuration config) {
        this.numQueryRunnerThreads = config.getInt(QUERY_RUNNER_CONFIG_KEY, DEFAULT_QUERY_RUNNER_THREADS);
        this.numQueryWorkerThreads = config.getInt(QUERY_WORKER_CONFIG_KEY, DEFAULT_QUERY_WORKER_THREADS);
        LOGGER.info("Initializing with {} query runner threads and {} worker threads", (Object)this.numQueryRunnerThreads, (Object)this.numQueryWorkerThreads);
        ThreadFactory queryRunnerFactory = new ThreadFactoryBuilder().setDaemon(false).setPriority(7).setNameFormat("pqr-%d").build();
        this.queryRunners = MoreExecutors.listeningDecorator(Executors.newFixedThreadPool(this.numQueryRunnerThreads, queryRunnerFactory));
        ThreadFactory queryWorkersFactory = new ThreadFactoryBuilder().setDaemon(false).setPriority(5).setNameFormat("pqw-%d").build();
        this.queryWorkers = MoreExecutors.listeningDecorator(Executors.newFixedThreadPool(this.numQueryWorkerThreads, queryWorkersFactory));
    }

    public void stop() {
        this.queryWorkers.shutdownNow();
        this.queryRunners.shutdownNow();
    }

    public final int getNumQueryRunnerThreads() {
        return this.numQueryRunnerThreads;
    }

    public final int getNumQueryWorkerThreads() {
        return this.numQueryWorkerThreads;
    }

    public final ListeningExecutorService getQueryRunners() {
        return this.queryRunners;
    }

    @VisibleForTesting
    public final ExecutorService getQueryWorkers() {
        return this.queryWorkers;
    }

    public abstract .QueryExecutorService getExecutorService(ServerQueryRequest var1, SchedulerGroupAccountant var2);

    public abstract int getTableThreadsHardLimit();

    public abstract int getTableThreadsSoftLimit();

    public boolean canSchedule(SchedulerGroupAccountant accountant) {
        return accountant.totalReservedThreads() < this.getTableThreadsHardLimit();
    }

    static {
        int numCores;
        LOGGER = LoggerFactory.getLogger(ResourceManager.class);
        DEFAULT_QUERY_RUNNER_THREADS = numCores = Runtime.getRuntime().availableProcessors();
        DEFAULT_QUERY_WORKER_THREADS = 2 * numCores;
    }
}

