/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.tokenbucket;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.AbstractSchedulerGroup;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.SchedulerGroup;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.SchedulerGroupAccountant;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.fcfs.FCFSSchedulerGroup;

public class TokenSchedulerGroup
extends AbstractSchedulerGroup {
    private final int tokenLifetimeMs;
    private final int numTokensPerMs;
    private int availableTokens;
    private long lastUpdateTimeMs;
    private long lastTokenTimeMs;
    private final Lock tokenLock = new ReentrantLock();
    private static final double ALPHA = 0.8;

    TokenSchedulerGroup(String schedGroupName, int numTokensPerMs, int tokenLifetimeMs) {
        super(schedGroupName);
        Preconditions.checkArgument(numTokensPerMs > 0);
        Preconditions.checkArgument(tokenLifetimeMs > 0);
        this.numTokensPerMs = numTokensPerMs;
        this.tokenLifetimeMs = tokenLifetimeMs;
        this.lastUpdateTimeMs = this.currentTimeMillis();
        this.availableTokens = numTokensPerMs * tokenLifetimeMs;
        this.lastTokenTimeMs = this.lastUpdateTimeMs;
    }

    int getAvailableTokens() {
        return this.consumeTokens();
    }

    @Override
    public void incrementThreads() {
        this.consumeTokens();
        super.incrementThreads();
    }

    @Override
    public void decrementThreads() {
        this.consumeTokens();
        super.decrementThreads();
    }

    @Override
    public void startQuery() {
        this.consumeTokens();
        super.startQuery();
    }

    @Override
    public void endQuery() {
        this.consumeTokens();
        super.endQuery();
    }

    @Override
    public int compareTo(SchedulerGroupAccountant rhs) {
        int rightTokens;
        if (rhs == null) {
            return 1;
        }
        if (this == rhs) {
            return 0;
        }
        int leftTokens = this.getAvailableTokens();
        if (leftTokens > (rightTokens = ((TokenSchedulerGroup)rhs).getAvailableTokens())) {
            return 1;
        }
        if (leftTokens < rightTokens) {
            return -1;
        }
        return FCFSSchedulerGroup.compare(this, (SchedulerGroup)rhs);
    }

    public String toString() {
        return String.format(" {%s:[%d,%d,%d,%d,%d]},", this.name(), this.getAvailableTokens(), this.numPending(), this.numRunning(), this.getThreadsInUse(), this.totalReservedThreads());
    }

    private int consumeTokens() {
        try (TokenLockManager lm = new TokenLockManager(this.tokenLock);){
            long currentTimeMs = this.currentTimeMillis();
            int diffMs = (int)(currentTimeMs - this.lastUpdateTimeMs);
            if (diffMs <= 0) {
                int n = this.availableTokens;
                return n;
            }
            int threads = this.threadsInUse.get();
            long nextTokenTime = this.lastTokenTimeMs + (long)this.tokenLifetimeMs;
            if (nextTokenTime > currentTimeMs) {
                this.availableTokens -= diffMs * threads;
            } else {
                this.availableTokens = (int)((long)this.availableTokens - (nextTokenTime - this.lastUpdateTimeMs) * (long)threads);
                while (nextTokenTime <= currentTimeMs) {
                    this.availableTokens = (int)(0.8 * (double)this.tokenLifetimeMs * (double)this.numTokensPerMs + 0.19999999999999996 * (double)(this.availableTokens - this.tokenLifetimeMs * threads));
                    nextTokenTime += (long)this.tokenLifetimeMs;
                }
                this.lastTokenTimeMs = nextTokenTime - (long)this.tokenLifetimeMs;
                this.availableTokens = (int)((long)this.availableTokens - (currentTimeMs - this.lastTokenTimeMs) * (long)threads);
            }
            this.lastUpdateTimeMs = currentTimeMs;
            int n = this.availableTokens;
            return n;
        }
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    private class TokenLockManager
    implements AutoCloseable {
        private final Lock lock;

        TokenLockManager(Lock lock) {
            this.lock = lock;
            this.lock.lock();
        }

        @Override
        public void close() {
            this.lock.unlock();
        }
    }
}

