/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.selection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Block;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.SelectionFetcher;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.comparator.CompositeDocIdValComparator;
import org.apache.pinot.common.request.Selection;
import org.apache.pinot.common.request.SelectionSort;
import org.apache.pinot.common.response.ServerInstance;
import org.apache.pinot.common.response.broker.SelectionResults;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;

public class SelectionOperatorService {
    private final List<String> _selectionColumns;
    private final List<SelectionSort> _sortSequence;
    private final DataSchema _dataSchema;
    private final int _selectionOffset;
    private final int _maxNumRows;
    private final PriorityQueue<Serializable[]> _rows;
    private long _numDocsScanned = 0L;

    public SelectionOperatorService(@Nonnull Selection selection, @Nonnull IndexSegment indexSegment) {
        this._selectionColumns = SelectionOperatorUtils.getSelectionColumns(selection.getSelectionColumns(), indexSegment);
        this._sortSequence = this.getSortSequence(selection.getSelectionSortSequence());
        this._dataSchema = SelectionOperatorUtils.extractDataSchema(this._sortSequence, this._selectionColumns, indexSegment);
        this._selectionOffset = selection.getOffset();
        this._maxNumRows = this._selectionOffset + selection.getSize();
        this._rows = new PriorityQueue<Serializable[]>(this._maxNumRows, this.getStrictComparator());
    }

    public SelectionOperatorService(@Nonnull Selection selection, @Nonnull DataSchema dataSchema) {
        this._selectionColumns = SelectionOperatorUtils.getSelectionColumns(selection.getSelectionColumns(), dataSchema);
        this._sortSequence = this.getSortSequence(selection.getSelectionSortSequence());
        this._dataSchema = dataSchema;
        this._selectionOffset = selection.getOffset();
        this._maxNumRows = this._selectionOffset + selection.getSize();
        this._rows = new PriorityQueue<Serializable[]>(this._maxNumRows, this.getTypeCompatibleComparator());
    }

    @Nonnull
    private List<SelectionSort> getSortSequence(List<SelectionSort> selectionSorts) {
        ArrayList<SelectionSort> deDupedSelectionSorts = new ArrayList<SelectionSort>();
        HashSet<String> sortColumns = new HashSet<String>();
        for (SelectionSort selectionSort : selectionSorts) {
            String sortColumn = selectionSort.getColumn();
            if (sortColumns.contains(sortColumn)) continue;
            deDupedSelectionSorts.add(selectionSort);
            sortColumns.add(sortColumn);
        }
        return deDupedSelectionSorts;
    }

    @Nonnull
    private Comparator<Serializable[]> getStrictComparator() {
        return new Comparator<Serializable[]>(){

            @Override
            public int compare(Serializable[] o1, Serializable[] o2) {
                int numSortColumns = SelectionOperatorService.this._sortSequence.size();
                for (int i = 0; i < numSortColumns; ++i) {
                    int ret = 0;
                    SelectionSort selectionSort = (SelectionSort)SelectionOperatorService.this._sortSequence.get(i);
                    Serializable v1 = o1[i];
                    Serializable v2 = o2[i];
                    switch (SelectionOperatorService.this._dataSchema.getColumnDataType(i)) {
                        case INT: {
                            if (!selectionSort.isIsAsc()) {
                                ret = ((Integer)v1).compareTo((Integer)v2);
                                break;
                            }
                            ret = ((Integer)v2).compareTo((Integer)v1);
                            break;
                        }
                        case LONG: {
                            if (!selectionSort.isIsAsc()) {
                                ret = ((Long)v1).compareTo((Long)v2);
                                break;
                            }
                            ret = ((Long)v2).compareTo((Long)v1);
                            break;
                        }
                        case FLOAT: {
                            if (!selectionSort.isIsAsc()) {
                                ret = ((Float)v1).compareTo((Float)v2);
                                break;
                            }
                            ret = ((Float)v2).compareTo((Float)v1);
                            break;
                        }
                        case DOUBLE: {
                            if (!selectionSort.isIsAsc()) {
                                ret = ((Double)v1).compareTo((Double)v2);
                                break;
                            }
                            ret = ((Double)v2).compareTo((Double)v1);
                            break;
                        }
                        case STRING: {
                            if (!selectionSort.isIsAsc()) {
                                ret = ((String)((Object)v1)).compareTo((String)((Object)v2));
                                break;
                            }
                            ret = ((String)((Object)v2)).compareTo((String)((Object)v1));
                            break;
                        }
                    }
                    if (ret == 0) continue;
                    return ret;
                }
                return 0;
            }
        };
    }

    @Nonnull
    private Comparator<Serializable[]> getTypeCompatibleComparator() {
        return new Comparator<Serializable[]>(){

            @Override
            public int compare(Serializable[] o1, Serializable[] o2) {
                int numSortColumns = SelectionOperatorService.this._sortSequence.size();
                for (int i = 0; i < numSortColumns; ++i) {
                    int ret = 0;
                    SelectionSort selectionSort = (SelectionSort)SelectionOperatorService.this._sortSequence.get(i);
                    Serializable v1 = o1[i];
                    Serializable v2 = o2[i];
                    if (v1 instanceof Number) {
                        ret = !selectionSort.isIsAsc() ? Double.compare(((Number)v1).doubleValue(), ((Number)v2).doubleValue()) : Double.compare(((Number)v2).doubleValue(), ((Number)v1).doubleValue());
                    } else if (v1 instanceof String) {
                        ret = !selectionSort.isIsAsc() ? ((String)((Object)v1)).compareTo((String)((Object)v2)) : ((String)((Object)v2)).compareTo((String)((Object)v1));
                    }
                    if (ret == 0) continue;
                    return ret;
                }
                return 0;
            }
        };
    }

    @Nonnull
    public DataSchema getDataSchema() {
        return this._dataSchema;
    }

    @Nonnull
    public PriorityQueue<Serializable[]> getRows() {
        return this._rows;
    }

    public long getNumDocsScanned() {
        return this._numDocsScanned;
    }

    public void iterateOnBlocksWithOrdering(@Nonnull BlockDocIdIterator blockDocIdIterator, @Nonnull Block[] blocks) {
        int docId;
        CompositeDocIdValComparator rowDocIdComparator = new CompositeDocIdValComparator(this._sortSequence, blocks);
        PriorityQueue<Integer> rowDocIdPriorityQueue = new PriorityQueue<Integer>(this._maxNumRows, rowDocIdComparator);
        while ((docId = blockDocIdIterator.next()) != Integer.MIN_VALUE) {
            ++this._numDocsScanned;
            SelectionOperatorUtils.addToPriorityQueue(docId, rowDocIdPriorityQueue, this._maxNumRows);
        }
        SelectionFetcher selectionFetcher = new SelectionFetcher(blocks, this._dataSchema);
        ArrayList<Serializable[]> rows = new ArrayList<Serializable[]>(rowDocIdPriorityQueue.size());
        for (int rowDocId : rowDocIdPriorityQueue) {
            rows.add(selectionFetcher.getRow(rowDocId));
        }
        SelectionOperatorUtils.mergeWithOrdering(this._rows, rows, this._maxNumRows);
    }

    public void reduceWithOrdering(@Nonnull Map<ServerInstance, DataTable> selectionResults) {
        for (DataTable dataTable : selectionResults.values()) {
            int numRows = dataTable.getNumberOfRows();
            for (int rowId = 0; rowId < numRows; ++rowId) {
                Serializable[] row = SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId);
                SelectionOperatorUtils.addToPriorityQueue(row, this._rows, this._maxNumRows);
            }
        }
    }

    @Nonnull
    public SelectionResults renderSelectionResultsWithOrdering() {
        LinkedList<Serializable[]> rowsInSelectionResults = new LinkedList<Serializable[]>();
        int[] columnIndices = SelectionOperatorUtils.getColumnIndicesWithOrdering(this._selectionColumns, this._dataSchema);
        while (this._rows.size() > this._selectionOffset) {
            rowsInSelectionResults.addFirst(SelectionOperatorUtils.extractColumns(this._rows.poll(), columnIndices));
        }
        return new SelectionResults(this._selectionColumns, rowsInSelectionResults);
    }
}

