/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.selection;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSourceMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.common.request.Selection;
import org.apache.pinot.common.request.SelectionSort;
import org.apache.pinot.common.response.ServerInstance;
import org.apache.pinot.common.response.broker.SelectionResults;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;

public class SelectionOperatorUtils {
    private static final String INT_PATTERN = "##########";
    private static final String LONG_PATTERN = "####################";
    private static final String FLOAT_PATTERN = "#########0.0####";
    private static final String DOUBLE_PATTERN = "###################0.0#########";
    private static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = DecimalFormatSymbols.getInstance(Locale.US);

    private SelectionOperatorUtils() {
    }

    @Nonnull
    public static List<String> getSelectionColumns(@Nonnull List<String> selectionColumns, @Nonnull IndexSegment indexSegment) {
        if (selectionColumns.size() == 1 && selectionColumns.get(0).equals("*")) {
            LinkedList<String> allColumns = new LinkedList<String>(indexSegment.getPhysicalColumnNames());
            Set<String> columnNames = indexSegment.getPhysicalColumnNames();
            Collections.sort(allColumns);
            return allColumns;
        }
        return selectionColumns;
    }

    @Nonnull
    public static Set<String> extractSelectionRelatedColumns(@Nonnull Selection selection, @Nonnull IndexSegment indexSegment) {
        HashSet<String> selectionColumns = new HashSet<String>(SelectionOperatorUtils.getSelectionColumns(selection.getSelectionColumns(), indexSegment));
        if (selection.getSelectionSortSequence() != null) {
            for (SelectionSort selectionSort : selection.getSelectionSortSequence()) {
                selectionColumns.add(selectionSort.getColumn());
            }
        }
        return selectionColumns;
    }

    @Nonnull
    public static DataSchema extractDataSchema(@Nullable List<SelectionSort> sortSequence, @Nonnull List<String> selectionColumns, @Nonnull IndexSegment indexSegment) {
        ArrayList<String> columnList = new ArrayList<String>();
        HashSet<String> columnSet = new HashSet<String>();
        if (sortSequence != null) {
            for (SelectionSort selectionSort : sortSequence) {
                String column = selectionSort.getColumn();
                columnList.add(column);
                columnSet.add(column);
            }
        }
        for (String column : selectionColumns) {
            if (columnSet.contains(column)) continue;
            columnList.add(column);
            columnSet.add(column);
        }
        int numColumns = columnList.size();
        String[] columnNames = new String[numColumns];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            String columnName;
            columnNames[i] = columnName = (String)columnList.get(i);
            DataSourceMetadata columnMetadata = indexSegment.getDataSource(columnName).getDataSourceMetadata();
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataType(columnMetadata.getDataType(), columnMetadata.isSingleValue());
        }
        return new DataSchema(columnNames, columnDataTypes);
    }

    @Nonnull
    public static List<String> getSelectionColumns(@Nonnull List<String> selectionColumns, @Nonnull DataSchema dataSchema) {
        if (selectionColumns.size() == 1 && selectionColumns.get(0).equals("*")) {
            int numColumns = dataSchema.size();
            ArrayList<String> allColumns = new ArrayList<String>(numColumns);
            for (int i = 0; i < numColumns; ++i) {
                allColumns.add(dataSchema.getColumnName(i));
            }
            Collections.sort(allColumns);
            return allColumns;
        }
        return selectionColumns;
    }

    public static void mergeWithoutOrdering(@Nonnull Collection<Serializable[]> mergedRows, @Nonnull Collection<Serializable[]> rowsToMerge, int selectionSize) {
        Iterator<Serializable[]> iterator = rowsToMerge.iterator();
        while (mergedRows.size() < selectionSize && iterator.hasNext()) {
            mergedRows.add(iterator.next());
        }
    }

    public static void mergeWithOrdering(@Nonnull PriorityQueue<Serializable[]> mergedRows, @Nonnull Collection<Serializable[]> rowsToMerge, int maxNumRows) {
        for (Serializable[] row : rowsToMerge) {
            SelectionOperatorUtils.addToPriorityQueue(row, mergedRows, maxNumRows);
        }
    }

    @Nonnull
    public static DataTable getDataTableFromRows(@Nonnull Collection<Serializable[]> rows, @Nonnull DataSchema dataSchema) throws Exception {
        int numColumns = dataSchema.size();
        DataTableBuilder dataTableBuilder = new DataTableBuilder(dataSchema);
        for (Serializable[] row : rows) {
            dataTableBuilder.startRow();
            block13: for (int i = 0; i < numColumns; ++i) {
                Serializable columnValue = row[i];
                DataSchema.ColumnDataType columnDataType = dataSchema.getColumnDataType(i);
                switch (columnDataType) {
                    case INT: {
                        dataTableBuilder.setColumn(i, ((Number)columnValue).intValue());
                        continue block13;
                    }
                    case LONG: {
                        dataTableBuilder.setColumn(i, ((Number)columnValue).longValue());
                        continue block13;
                    }
                    case FLOAT: {
                        dataTableBuilder.setColumn(i, ((Number)columnValue).floatValue());
                        continue block13;
                    }
                    case DOUBLE: {
                        dataTableBuilder.setColumn(i, ((Number)columnValue).doubleValue());
                        continue block13;
                    }
                    case STRING: 
                    case BYTES: {
                        dataTableBuilder.setColumn(i, (String)((Object)columnValue));
                        continue block13;
                    }
                    case INT_ARRAY: {
                        dataTableBuilder.setColumn(i, (int[])columnValue);
                        continue block13;
                    }
                    case LONG_ARRAY: {
                        int j;
                        int length;
                        int[] ints;
                        if (columnValue instanceof int[]) {
                            ints = (int[])columnValue;
                            length = ints.length;
                            long[] longs = new long[length];
                            for (j = 0; j < length; ++j) {
                                longs[j] = ints[j];
                            }
                            dataTableBuilder.setColumn(i, longs);
                            continue block13;
                        }
                        dataTableBuilder.setColumn(i, (long[])columnValue);
                        continue block13;
                    }
                    case FLOAT_ARRAY: {
                        dataTableBuilder.setColumn(i, (float[])columnValue);
                        continue block13;
                    }
                    case DOUBLE_ARRAY: {
                        double[] doubles;
                        int j;
                        int length;
                        int[] ints;
                        if (columnValue instanceof int[]) {
                            ints = (int[])columnValue;
                            length = ints.length;
                            doubles = new double[length];
                            for (j = 0; j < length; ++j) {
                                doubles[j] = ints[j];
                            }
                            dataTableBuilder.setColumn(i, doubles);
                            continue block13;
                        }
                        if (columnValue instanceof long[]) {
                            long[] longs = (long[])columnValue;
                            length = longs.length;
                            doubles = new double[length];
                            for (j = 0; j < length; ++j) {
                                doubles[j] = longs[j];
                            }
                            dataTableBuilder.setColumn(i, doubles);
                            continue block13;
                        }
                        if (columnValue instanceof float[]) {
                            float[] floats = (float[])columnValue;
                            length = floats.length;
                            doubles = new double[length];
                            for (j = 0; j < length; ++j) {
                                doubles[j] = floats[j];
                            }
                            dataTableBuilder.setColumn(i, doubles);
                            continue block13;
                        }
                        dataTableBuilder.setColumn(i, (double[])columnValue);
                        continue block13;
                    }
                    case STRING_ARRAY: {
                        dataTableBuilder.setColumn(i, (String[])columnValue);
                        continue block13;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)columnDataType) + " for column: " + dataSchema.getColumnName(i));
                    }
                }
            }
            dataTableBuilder.finishRow();
        }
        return dataTableBuilder.build();
    }

    @Nonnull
    public static Serializable[] extractRowFromDataTable(@Nonnull DataTable dataTable, int rowId) {
        DataSchema dataSchema = dataTable.getDataSchema();
        int numColumns = dataSchema.size();
        Serializable[] row = new Serializable[numColumns];
        block13: for (int i = 0; i < numColumns; ++i) {
            DataSchema.ColumnDataType columnDataType = dataSchema.getColumnDataType(i);
            switch (columnDataType) {
                case INT: {
                    row[i] = Integer.valueOf(dataTable.getInt(rowId, i));
                    continue block13;
                }
                case LONG: {
                    row[i] = Long.valueOf(dataTable.getLong(rowId, i));
                    continue block13;
                }
                case FLOAT: {
                    row[i] = Float.valueOf(dataTable.getFloat(rowId, i));
                    continue block13;
                }
                case DOUBLE: {
                    row[i] = Double.valueOf(dataTable.getDouble(rowId, i));
                    continue block13;
                }
                case STRING: {
                    row[i] = dataTable.getString(rowId, i);
                    continue block13;
                }
                case BYTES: {
                    row[i] = dataTable.getString(rowId, i);
                    continue block13;
                }
                case INT_ARRAY: {
                    row[i] = dataTable.getIntArray(rowId, i);
                    continue block13;
                }
                case LONG_ARRAY: {
                    row[i] = dataTable.getLongArray(rowId, i);
                    continue block13;
                }
                case FLOAT_ARRAY: {
                    row[i] = dataTable.getFloatArray(rowId, i);
                    continue block13;
                }
                case DOUBLE_ARRAY: {
                    row[i] = dataTable.getDoubleArray(rowId, i);
                    continue block13;
                }
                case STRING_ARRAY: {
                    row[i] = dataTable.getStringArray(rowId, i);
                    continue block13;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported column data type: " + (Object)((Object)columnDataType) + " for column: " + dataSchema.getColumnName(i));
                }
            }
        }
        return row;
    }

    @Nonnull
    public static List<Serializable[]> reduceWithoutOrdering(@Nonnull Map<ServerInstance, DataTable> selectionResults, int selectionSize) {
        ArrayList<Serializable[]> rows = new ArrayList<Serializable[]>(selectionSize);
        for (DataTable dataTable : selectionResults.values()) {
            int numRows = dataTable.getNumberOfRows();
            for (int rowId = 0; rowId < numRows; ++rowId) {
                if (rows.size() >= selectionSize) {
                    return rows;
                }
                rows.add(SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId));
            }
        }
        return rows;
    }

    @Nonnull
    public static SelectionResults renderSelectionResultsWithoutOrdering(@Nonnull List<Serializable[]> rows, @Nonnull DataSchema dataSchema, @Nonnull List<String> selectionColumns) {
        int[] columnIndices = SelectionOperatorUtils.getColumnIndicesWithoutOrdering(selectionColumns, dataSchema);
        int numRows = rows.size();
        for (int i = 0; i < numRows; ++i) {
            rows.set(i, SelectionOperatorUtils.extractColumns(rows.get(i), columnIndices));
        }
        return new SelectionResults(selectionColumns, rows);
    }

    public static int[] getColumnIndicesWithoutOrdering(@Nonnull List<String> selectionColumns, @Nonnull DataSchema dataSchema) {
        int i;
        int numSelectionColumns = selectionColumns.size();
        int[] columnIndices = new int[numSelectionColumns];
        HashMap<String, Integer> dataSchemaIndices = new HashMap<String, Integer>(numSelectionColumns);
        for (i = 0; i < numSelectionColumns; ++i) {
            dataSchemaIndices.put(dataSchema.getColumnName(i), i);
        }
        for (i = 0; i < numSelectionColumns; ++i) {
            columnIndices[i] = (Integer)dataSchemaIndices.get(selectionColumns.get(i));
        }
        return columnIndices;
    }

    public static int[] getColumnIndicesWithOrdering(@Nonnull List<String> selectionColumns, @Nonnull DataSchema dataSchema) {
        int i;
        int numSelectionColumns = selectionColumns.size();
        int[] columnIndices = new int[numSelectionColumns];
        int numColumnsInDataSchema = dataSchema.size();
        HashMap<String, Integer> dataSchemaIndices = new HashMap<String, Integer>(numColumnsInDataSchema);
        for (i = 0; i < numColumnsInDataSchema; ++i) {
            dataSchemaIndices.put(dataSchema.getColumnName(i), i);
        }
        for (i = 0; i < numSelectionColumns; ++i) {
            columnIndices[i] = (Integer)dataSchemaIndices.get(selectionColumns.get(i));
        }
        return columnIndices;
    }

    @Nonnull
    public static Serializable[] extractColumns(@Nonnull Serializable[] row, @Nonnull int[] columnIndices) {
        int numColumns = columnIndices.length;
        Serializable[] extractedRow = new Serializable[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            int columnIndex = columnIndices[i];
            extractedRow[i] = row[columnIndex];
        }
        return extractedRow;
    }

    public static List<Serializable[]> formatRowsWithOrdering(@Nonnull List<Serializable[]> rows, @Nonnull int[] columnIndices, @Nonnull DataSchema dataSchema) {
        int numRows = rows.size();
        for (int i = 0; i < numRows; ++i) {
            rows.set(i, SelectionOperatorUtils.formatRowWithOrdering(rows.get(i), columnIndices, dataSchema));
        }
        return rows;
    }

    private static Serializable[] formatRowWithOrdering(@Nonnull Serializable[] row, @Nonnull int[] columnIndices, @Nonnull DataSchema dataSchema) {
        int numColumns = columnIndices.length;
        for (int i = 0; i < numColumns; ++i) {
            int columnIndex = columnIndices[i];
            row[i] = SelectionOperatorUtils.getFormattedValue(row[i], dataSchema.getColumnDataType(columnIndex));
        }
        return row;
    }

    public static List<Serializable[]> formatRowsWithoutOrdering(@Nonnull List<Serializable[]> rows, @Nonnull DataSchema dataSchema) {
        int numRows = rows.size();
        for (int i = 0; i < numRows; ++i) {
            rows.set(i, SelectionOperatorUtils.formatRowWithoutOrdering(rows.get(i), dataSchema));
        }
        return rows;
    }

    private static Serializable[] formatRowWithoutOrdering(@Nonnull Serializable[] row, @Nonnull DataSchema dataSchema) {
        int numColumns = row.length;
        for (int i = 0; i < numColumns; ++i) {
            row[i] = SelectionOperatorUtils.getFormattedValue(row[i], dataSchema.getColumnDataType(i));
        }
        return row;
    }

    @Nonnull
    private static String intFormat(int value) {
        DecimalFormat intFormatter = new DecimalFormat(INT_PATTERN, DECIMAL_FORMAT_SYMBOLS);
        return intFormatter.format(value);
    }

    @Nonnull
    private static String longFormat(long value) {
        DecimalFormat longFormatter = new DecimalFormat(LONG_PATTERN, DECIMAL_FORMAT_SYMBOLS);
        return longFormatter.format(value);
    }

    @Nonnull
    private static String floatFormat(float value) {
        DecimalFormat floatFormatter = new DecimalFormat(FLOAT_PATTERN, DECIMAL_FORMAT_SYMBOLS);
        return floatFormatter.format(value);
    }

    @Nonnull
    private static String doubleFormat(double value) {
        DecimalFormat doubleFormatter = new DecimalFormat(DOUBLE_PATTERN, DECIMAL_FORMAT_SYMBOLS);
        return doubleFormatter.format(value);
    }

    @Nonnull
    private static Serializable getFormattedValue(@Nonnull Serializable value, @Nonnull DataSchema.ColumnDataType dataType) {
        switch (dataType) {
            case INT: {
                return SelectionOperatorUtils.intFormat(((Number)value).intValue());
            }
            case LONG: {
                return SelectionOperatorUtils.longFormat(((Number)value).longValue());
            }
            case FLOAT: {
                return SelectionOperatorUtils.floatFormat(((Number)value).floatValue());
            }
            case DOUBLE: {
                return SelectionOperatorUtils.doubleFormat(((Number)value).doubleValue());
            }
            case INT_ARRAY: {
                int[] ints = (int[])value;
                int length = ints.length;
                String[] formattedValue = new String[length];
                for (int i = 0; i < length; ++i) {
                    formattedValue[i] = SelectionOperatorUtils.intFormat(ints[i]);
                }
                return formattedValue;
            }
            case LONG_ARRAY: {
                String[] formattedValue;
                if (value instanceof int[]) {
                    int[] ints = (int[])value;
                    int length = ints.length;
                    formattedValue = new String[length];
                    for (int i = 0; i < length; ++i) {
                        formattedValue[i] = SelectionOperatorUtils.longFormat(ints[i]);
                    }
                } else {
                    long[] longs = (long[])value;
                    int length = longs.length;
                    formattedValue = new String[length];
                    for (int i = 0; i < length; ++i) {
                        formattedValue[i] = SelectionOperatorUtils.longFormat(longs[i]);
                    }
                }
                return formattedValue;
            }
            case FLOAT_ARRAY: {
                float[] floats = (float[])value;
                int length = floats.length;
                String[] formattedValue = new String[length];
                for (int i = 0; i < length; ++i) {
                    formattedValue[i] = SelectionOperatorUtils.floatFormat(floats[i]);
                }
                return formattedValue;
            }
            case DOUBLE_ARRAY: {
                if (value instanceof int[]) {
                    int[] ints = (int[])value;
                    int length = ints.length;
                    String[] formattedValue = new String[length];
                    for (int i = 0; i < length; ++i) {
                        formattedValue[i] = SelectionOperatorUtils.doubleFormat(ints[i]);
                    }
                    return formattedValue;
                }
                if (value instanceof long[]) {
                    long[] longs = (long[])value;
                    int length = longs.length;
                    String[] formattedValue = new String[length];
                    for (int i = 0; i < length; ++i) {
                        formattedValue[i] = SelectionOperatorUtils.doubleFormat(longs[i]);
                    }
                    return formattedValue;
                }
                if (value instanceof float[]) {
                    float[] floats = (float[])value;
                    int length = floats.length;
                    String[] formattedValue = new String[length];
                    for (int i = 0; i < length; ++i) {
                        formattedValue[i] = SelectionOperatorUtils.doubleFormat(floats[i]);
                    }
                    return formattedValue;
                }
                double[] doubles = (double[])value;
                int length = doubles.length;
                String[] formattedValue = new String[length];
                for (int i = 0; i < length; ++i) {
                    formattedValue[i] = SelectionOperatorUtils.doubleFormat(doubles[i]);
                }
                return formattedValue;
            }
        }
        return value;
    }

    public static <T> void addToPriorityQueue(@Nonnull T value, @Nonnull PriorityQueue<T> queue, int maxNumValues) {
        if (queue.size() < maxNumValues) {
            queue.add(value);
        } else if (queue.comparator().compare(queue.peek(), value) < 0) {
            queue.poll();
            queue.offer(value);
        }
    }
}

