/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.converter;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer.CompoundTransformer;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.generator.SegmentGeneratorConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.generator.SegmentVersion;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.mutable.MutableSegmentImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.io.compression.ChunkCompressorFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.converter.RealtimeSegmentRecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.converter.stats.RealtimeSegmentSegmentCreationDataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.common.config.ColumnPartitionConfig;
import org.apache.pinot.common.config.SegmentPartitionConfig;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.data.StarTreeIndexSpec;
import org.apache.pinot.common.data.TimeFieldSpec;
import org.apache.pinot.common.data.TimeGranularitySpec;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMetrics;

public class RealtimeSegmentConverter {
    private MutableSegmentImpl realtimeSegmentImpl;
    private String outputPath;
    private Schema dataSchema;
    private String tableName;
    private String timeColumnName;
    private String segmentName;
    private String sortedColumn;
    private List<String> invertedIndexColumns;
    private List<String> noDictionaryColumns;
    private StarTreeIndexSpec starTreeIndexSpec;

    public RealtimeSegmentConverter(MutableSegmentImpl realtimeSegment, String outputPath, Schema schema, String tableName, String timeColumnName, String segmentName, String sortedColumn, List<String> invertedIndexColumns, List<String> noDictionaryColumns, StarTreeIndexSpec starTreeIndexSpec) {
        if (new File(outputPath).exists()) {
            throw new IllegalAccessError("path already exists:" + outputPath);
        }
        this.realtimeSegmentImpl = realtimeSegment;
        this.outputPath = outputPath;
        this.invertedIndexColumns = new ArrayList<String>(invertedIndexColumns);
        if (sortedColumn != null && this.invertedIndexColumns.contains(sortedColumn)) {
            this.invertedIndexColumns.remove(sortedColumn);
        }
        this.dataSchema = this.getUpdatedSchema(schema);
        this.sortedColumn = sortedColumn;
        this.tableName = tableName;
        this.segmentName = segmentName;
        this.noDictionaryColumns = noDictionaryColumns;
        this.starTreeIndexSpec = starTreeIndexSpec;
    }

    public RealtimeSegmentConverter(MutableSegmentImpl realtimeSegment, String outputPath, Schema schema, String tableName, String timeColumnName, String segmentName, String sortedColumn) {
        this(realtimeSegment, outputPath, schema, tableName, timeColumnName, segmentName, sortedColumn, new ArrayList<String>(), new ArrayList<String>(), null);
    }

    public void build(@Nullable SegmentVersion segmentVersion, ServerMetrics serverMetrics) throws Exception {
        RealtimeSegmentRecordReader reader = this.sortedColumn == null ? new RealtimeSegmentRecordReader(this.realtimeSegmentImpl, this.dataSchema) : new RealtimeSegmentRecordReader(this.realtimeSegmentImpl, this.dataSchema, this.sortedColumn);
        SegmentGeneratorConfig genConfig = new SegmentGeneratorConfig(this.dataSchema);
        if (this.invertedIndexColumns != null && !this.invertedIndexColumns.isEmpty()) {
            for (String string : this.invertedIndexColumns) {
                genConfig.createInvertedIndexForColumn(string);
            }
        }
        if (this.noDictionaryColumns != null) {
            genConfig.setRawIndexCreationColumns(this.noDictionaryColumns);
            HashMap<String, ChunkCompressorFactory.CompressionType> columnToCompressionType = new HashMap<String, ChunkCompressorFactory.CompressionType>();
            for (String column : this.noDictionaryColumns) {
                FieldSpec fieldSpec = this.dataSchema.getFieldSpecFor(column);
                if (!fieldSpec.getFieldType().equals((Object)FieldSpec.FieldType.METRIC)) continue;
                columnToCompressionType.put(column, ChunkCompressorFactory.CompressionType.PASS_THROUGH);
            }
            genConfig.setRawIndexCompressionType(columnToCompressionType);
        }
        if (this.starTreeIndexSpec != null) {
            genConfig.enableStarTreeIndex(this.starTreeIndexSpec);
        }
        genConfig.setTimeColumnName(this.dataSchema.getTimeFieldSpec().getOutgoingTimeColumnName());
        genConfig.setSegmentTimeUnit(this.dataSchema.getTimeFieldSpec().getOutgoingGranularitySpec().getTimeType());
        if (segmentVersion != null) {
            genConfig.setSegmentVersion(segmentVersion);
        }
        genConfig.setTableName(this.tableName);
        genConfig.setOutDir(this.outputPath);
        genConfig.setSegmentName(this.segmentName);
        SegmentPartitionConfig segmentPartitionConfig = this.realtimeSegmentImpl.getSegmentPartitionConfig();
        genConfig.setSegmentPartitionConfig(segmentPartitionConfig);
        SegmentIndexCreationDriverImpl segmentIndexCreationDriverImpl = new SegmentIndexCreationDriverImpl();
        RealtimeSegmentSegmentCreationDataSource dataSource = new RealtimeSegmentSegmentCreationDataSource(this.realtimeSegmentImpl, reader, this.dataSchema);
        segmentIndexCreationDriverImpl.init(genConfig, dataSource, CompoundTransformer.getPassThroughTransformer());
        segmentIndexCreationDriverImpl.build();
        if (segmentPartitionConfig != null && segmentPartitionConfig.getColumnPartitionMap() != null) {
            Map<String, ColumnPartitionConfig> columnPartitionMap = segmentPartitionConfig.getColumnPartitionMap();
            for (String columnName : columnPartitionMap.keySet()) {
                int numPartitions = segmentIndexCreationDriverImpl.getSegmentStats().getColumnProfileFor(columnName).getPartitions().size();
                serverMetrics.addValueToTableGauge(this.tableName, ServerGauge.REALTIME_SEGMENT_NUM_PARTITIONS, numPartitions);
            }
        }
    }

    @VisibleForTesting
    public Schema getUpdatedSchema(Schema original) {
        TimeFieldSpec tfs = original.getTimeFieldSpec();
        TimeGranularitySpec outgoing = tfs.getOutgoingGranularitySpec();
        TimeFieldSpec newTimeSpec = new TimeFieldSpec(outgoing);
        Schema newSchema = new Schema();
        newSchema.addField(newTimeSpec);
        for (String col : original.getPhysicalColumnNames()) {
            if (col.equals(tfs.getName())) continue;
            newSchema.addField(original.getFieldSpecFor(col));
        }
        return newSchema;
    }
}

