/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary.MutableDictionary;

public abstract class BaseOnHeapMutableDictionary
extends MutableDictionary {
    private static final int SHIFT_OFFSET = 13;
    private static final int INITIAL_DICTIONARY_SIZE = 8192;
    private static final int MASK = 8191;
    private final Map<Object, Integer> _valueToDictId = new ConcurrentHashMap<Object, Integer>(8192);
    private final Object[][] _dictIdToValue = new Object[8192][];
    private int _entriesIndexed = 0;

    @Override
    @Nonnull
    public Object get(int dictId) {
        return this._dictIdToValue[dictId >>> 13][dictId & 0x1FFF];
    }

    @Override
    public int length() {
        return this._entriesIndexed;
    }

    @Override
    public int getAvgValueSize() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean isEmpty() {
        return this._entriesIndexed == 0;
    }

    @Override
    public void close() throws IOException {
    }

    protected void indexValue(@Nonnull Object value) {
        if (!this._valueToDictId.containsKey(value)) {
            int arrayIndex = this._entriesIndexed >>> 13;
            int arrayOffset = this._entriesIndexed & 0x1FFF;
            if (arrayOffset == 0) {
                this._dictIdToValue[arrayIndex] = new Object[8192];
            }
            this._dictIdToValue[arrayIndex][arrayOffset] = value;
            this._valueToDictId.put(value, this._entriesIndexed);
            ++this._entriesIndexed;
        }
    }

    protected int getDictId(@Nonnull Object value) {
        Integer dictId = this._valueToDictId.get(value);
        if (dictId == null) {
            return -1;
        }
        return dictId;
    }
}

