/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary.BaseOnHeapMutableDictionary;

public class DoubleOnHeapMutableDictionary
extends BaseOnHeapMutableDictionary {
    private double _min = Double.MAX_VALUE;
    private double _max = Double.MIN_VALUE;

    @Override
    public int indexOf(Object rawValue) {
        if (rawValue instanceof String) {
            return this.getDictId(Double.valueOf((String)rawValue));
        }
        return this.getDictId(rawValue);
    }

    @Override
    public void index(@Nonnull Object rawValue) {
        if (rawValue instanceof Double) {
            this.indexValue(rawValue);
            this.updateMinMax((Double)rawValue);
        } else {
            Object[] values;
            for (Object value : values = (Object[])rawValue) {
                this.indexValue(value);
                this.updateMinMax((Double)value);
            }
        }
    }

    @Override
    public boolean inRange(@Nonnull String lower, @Nonnull String upper, int dictIdToCompare, boolean includeLower, boolean includeUpper) {
        double lowerDouble = Double.parseDouble(lower);
        double upperDouble = Double.parseDouble(upper);
        double valueToCompare = (Double)this.get(dictIdToCompare);
        if (includeLower ? valueToCompare < lowerDouble : valueToCompare <= lowerDouble) {
            return false;
        }
        return !(includeUpper ? valueToCompare > upperDouble : valueToCompare >= upperDouble);
    }

    @Override
    @Nonnull
    public Double getMinVal() {
        return this._min;
    }

    @Override
    @Nonnull
    public Double getMaxVal() {
        return this._max;
    }

    @Nonnull
    public double[] getSortedValues() {
        int numValues = this.length();
        double[] sortedValues = new double[numValues];
        for (int i = 0; i < numValues; ++i) {
            sortedValues[i] = (Double)this.get(i);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    @Override
    public int getIntValue(int dictId) {
        return ((Double)this.get(dictId)).intValue();
    }

    @Override
    public long getLongValue(int dictId) {
        return ((Double)this.get(dictId)).longValue();
    }

    @Override
    public float getFloatValue(int dictId) {
        return ((Double)this.get(dictId)).floatValue();
    }

    @Override
    public double getDoubleValue(int dictId) {
        return (Double)this.get(dictId);
    }

    private void updateMinMax(double value) {
        if (value < this._min) {
            this._min = value;
        }
        if (value > this._max) {
            this._max = value;
        }
    }
}

