/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary.BaseOnHeapMutableDictionary;

public class IntOnHeapMutableDictionary
extends BaseOnHeapMutableDictionary {
    private int _min = Integer.MAX_VALUE;
    private int _max = Integer.MIN_VALUE;

    @Override
    public int indexOf(Object rawValue) {
        if (rawValue instanceof String) {
            return this.getDictId(Integer.valueOf((String)rawValue));
        }
        return this.getDictId(rawValue);
    }

    @Override
    public void index(@Nonnull Object rawValue) {
        if (rawValue instanceof Integer) {
            this.indexValue(rawValue);
            this.updateMinMax((Integer)rawValue);
        } else {
            Object[] values;
            for (Object value : values = (Object[])rawValue) {
                this.indexValue(value);
                this.updateMinMax((Integer)value);
            }
        }
    }

    @Override
    public boolean inRange(@Nonnull String lower, @Nonnull String upper, int dictIdToCompare, boolean includeLower, boolean includeUpper) {
        int lowerInt = Integer.parseInt(lower);
        int upperInt = Integer.parseInt(upper);
        int valueToCompare = (Integer)this.get(dictIdToCompare);
        if (includeLower ? valueToCompare < lowerInt : valueToCompare <= lowerInt) {
            return false;
        }
        return !(includeUpper ? valueToCompare > upperInt : valueToCompare >= upperInt);
    }

    @Override
    @Nonnull
    public Integer getMinVal() {
        return this._min;
    }

    @Override
    @Nonnull
    public Integer getMaxVal() {
        return this._max;
    }

    @Nonnull
    public int[] getSortedValues() {
        int numValues = this.length();
        int[] sortedValues = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            sortedValues[i] = (Integer)this.get(i);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    @Override
    public int getIntValue(int dictId) {
        return (Integer)this.get(dictId);
    }

    @Override
    public long getLongValue(int dictId) {
        return ((Integer)this.get(dictId)).intValue();
    }

    @Override
    public float getFloatValue(int dictId) {
        return ((Integer)this.get(dictId)).intValue();
    }

    @Override
    public double getDoubleValue(int dictId) {
        return ((Integer)this.get(dictId)).intValue();
    }

    private void updateMinMax(int value) {
        if (value < this._min) {
            this._min = value;
        }
        if (value > this._max) {
            this._max = value;
        }
    }
}

