/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary.BaseOnHeapMutableDictionary;

public class StringOnHeapMutableDictionary
extends BaseOnHeapMutableDictionary {
    private String _min = null;
    private String _max = null;

    @Override
    public int indexOf(Object rawValue) {
        return this.getDictId(rawValue);
    }

    @Override
    public void index(@Nonnull Object rawValue) {
        if (rawValue instanceof String) {
            this.indexValue(rawValue);
            this.updateMinMax((String)rawValue);
        } else {
            Object[] values;
            for (Object value : values = (Object[])rawValue) {
                this.indexValue(value);
                this.updateMinMax((String)value);
            }
        }
    }

    @Override
    public boolean inRange(@Nonnull String lower, @Nonnull String upper, int dictIdToCompare, boolean includeLower, boolean includeUpper) {
        String valueToCompare = (String)this.get(dictIdToCompare);
        return this.valueInRange(lower, upper, includeLower, includeUpper, valueToCompare);
    }

    @Override
    @Nonnull
    public String getMinVal() {
        return this._min;
    }

    @Override
    @Nonnull
    public String getMaxVal() {
        return this._max;
    }

    @Nonnull
    public String[] getSortedValues() {
        int numValues = this.length();
        Object[] sortedValues = new String[numValues];
        for (int i = 0; i < numValues; ++i) {
            sortedValues[i] = (String)this.get(i);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    @Override
    public int getIntValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLongValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloatValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDoubleValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    private void updateMinMax(String value) {
        if (this._min == null) {
            this._min = value;
            this._max = value;
        } else {
            if (value.compareTo(this._min) < 0) {
                this._min = value;
            }
            if (value.compareTo(this._max) > 0) {
                this._max = value;
            }
        }
    }
}

