/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka;

import javax.annotation.Nonnull;
import org.apache.avro.generic.GenericData;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.util.AvroUtils;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.data.TimeFieldSpec;

public class AvroRecordToPinotRowGenerator {
    private final Schema _schema;
    private final FieldSpec _incomingTimeFieldSpec;

    public AvroRecordToPinotRowGenerator(@Nonnull Schema schema) {
        this._schema = schema;
        TimeFieldSpec timeFieldSpec = schema.getTimeFieldSpec();
        Preconditions.checkNotNull(timeFieldSpec);
        this._incomingTimeFieldSpec = new TimeFieldSpec(timeFieldSpec.getIncomingGranularitySpec());
    }

    @Nonnull
    public GenericRow transform(@Nonnull GenericData.Record from, @Nonnull GenericRow to) {
        for (FieldSpec fieldSpec : this._schema.getAllFieldSpecs()) {
            FieldSpec incomingFieldSpec = fieldSpec.getFieldType() == FieldSpec.FieldType.TIME ? this._incomingTimeFieldSpec : fieldSpec;
            String fieldName = incomingFieldSpec.getName();
            Object avroValue = from.get(fieldName);
            if (incomingFieldSpec.isSingleValueField()) {
                to.putField(fieldName, AvroUtils.transformAvroValueToObject(avroValue, incomingFieldSpec));
                continue;
            }
            to.putField(fieldName, AvroUtils.transformAvroArrayToObjectArray((GenericData.Array)avroValue, incomingFieldSpec));
        }
        return to;
    }
}

