/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.pinot.$internal.org.apache.commons.lang.StringUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka.AvroRecordToPinotRowGenerator;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamMessageDecoder;
import org.apache.pinot.common.utils.retry.RetryPolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class KafkaAvroMessageDecoder
implements StreamMessageDecoder<byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaAvroMessageDecoder.class);
    private static final String SCHEMA_REGISTRY_REST_URL = "schema.registry.rest.url";
    private static final String SCHEMA_REGISTRY_SCHEMA_NAME = "schema.registry.schema.name";
    private Schema defaultAvroSchema;
    private MD5AvroSchemaMap md5ToAvroSchemaMap;
    private static final Map<String, Schema> globalSchemaCache = new HashMap<String, Schema>();
    private static final String LATEST = "-latest";
    private final byte[] reusableMD5Bytes = new byte[16];
    private DecoderFactory decoderFactory;
    private AvroRecordToPinotRowGenerator avroRecordConvetrer;
    private static final int MAGIC_BYTE_LENGTH = 1;
    private static final int SCHEMA_HASH_LENGTH = 16;
    private static final int HEADER_LENGTH = 17;
    private static final int SCHEMA_HASH_START_OFFSET = 1;
    private static final int MAXIMUM_SCHEMA_FETCH_RETRY_COUNT = 5;
    private static final int MINIMUM_SCHEMA_FETCH_RETRY_TIME_MILLIS = 500;
    private static final float SCHEMA_FETCH_RETRY_EXPONENTIAL_BACKOFF_FACTOR = 2.0f;
    private String[] schemaRegistryUrls;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Map<String, String> props, org.apache.pinot.common.data.Schema indexingSchema, String topicName) throws Exception {
        for (String schemaRegistryUrl : this.schemaRegistryUrls = this.parseSchemaRegistryUrls(props.get(SCHEMA_REGISTRY_REST_URL))) {
            StringUtils.chomp(schemaRegistryUrl, "/");
        }
        String avroSchemaName = topicName;
        if (props.containsKey(SCHEMA_REGISTRY_SCHEMA_NAME) && props.get(SCHEMA_REGISTRY_SCHEMA_NAME) != null && !props.get(SCHEMA_REGISTRY_SCHEMA_NAME).isEmpty()) {
            avroSchemaName = props.get(SCHEMA_REGISTRY_SCHEMA_NAME);
        }
        Map<String, Schema> map = globalSchemaCache;
        synchronized (map) {
            String hashKey = avroSchemaName + LATEST;
            this.defaultAvroSchema = globalSchemaCache.get(hashKey);
            if (this.defaultAvroSchema == null) {
                this.defaultAvroSchema = this.fetchSchema("/latest_with_type=" + avroSchemaName);
                globalSchemaCache.put(hashKey, this.defaultAvroSchema);
                LOGGER.info("Populated schema cache with schema for {}", (Object)hashKey);
            }
        }
        this.avroRecordConvetrer = new AvroRecordToPinotRowGenerator(indexingSchema);
        this.decoderFactory = new DecoderFactory();
        this.md5ToAvroSchemaMap = new MD5AvroSchemaMap();
    }

    @Override
    public GenericRow decode(byte[] payload, GenericRow destination) {
        return this.decode(payload, 0, payload.length, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericRow decode(byte[] payload, int offset, int length, GenericRow destination) {
        if (payload == null || payload.length == 0 || length == 0) {
            return null;
        }
        System.arraycopy(payload, 1 + offset, this.reusableMD5Bytes, 0, 16);
        boolean schemaUpdateFailed = false;
        Schema schema = this.md5ToAvroSchemaMap.getSchema(this.reusableMD5Bytes);
        if (schema == null) {
            Map<String, Schema> map = globalSchemaCache;
            synchronized (map) {
                String hashKey = this.hex(this.reusableMD5Bytes);
                schema = globalSchemaCache.get(hashKey);
                if (schema == null) {
                    String schemaUri = "/id=" + this.hex(this.reusableMD5Bytes);
                    try {
                        schema = this.fetchSchema(schemaUri);
                        globalSchemaCache.put(hashKey, schema);
                        this.md5ToAvroSchemaMap.addSchema(this.reusableMD5Bytes, schema);
                    }
                    catch (Exception e) {
                        schema = this.defaultAvroSchema;
                        LOGGER.error("Error fetching schema using url {}. Attempting to continue with previous schema", (Object)schemaUri, (Object)e);
                        schemaUpdateFailed = true;
                    }
                } else {
                    LOGGER.info("Found schema for {} in cache", (Object)hashKey);
                    this.md5ToAvroSchemaMap.addSchema(this.reusableMD5Bytes, schema);
                }
            }
        }
        GenericDatumReader reader = new GenericDatumReader(schema);
        try {
            GenericData.Record avroRecord = (GenericData.Record)reader.read(null, (Decoder)this.decoderFactory.createBinaryDecoder(payload, 17 + offset, length - 17, null));
            return this.avroRecordConvetrer.transform(avroRecord, destination);
        }
        catch (IOException e) {
            LOGGER.error("Caught exception while reading message using schema {}{}", new Object[]{schema == null ? "null" : schema.getName(), schemaUpdateFailed ? "(possibly due to schema update failure)" : "", e});
            return null;
        }
    }

    private String hex(byte[] bytes) {
        StringBuilder builder = new StringBuilder(2 * bytes.length);
        for (byte aByte : bytes) {
            String hexString = Integer.toHexString(0xFF & aByte);
            if (hexString.length() < 2) {
                hexString = "0" + hexString;
            }
            builder.append(hexString);
        }
        return builder.toString();
    }

    private Schema fetchSchema(String reference) throws Exception {
        SchemaFetcher schemaFetcher = new SchemaFetcher(this.makeRandomUrl(reference));
        RetryPolicies.exponentialBackoffRetryPolicy(5, 500L, 2.0).attempt(schemaFetcher);
        return schemaFetcher.getSchema();
    }

    protected URL makeRandomUrl(String reference) throws MalformedURLException {
        Random rand = new Random();
        int randomInteger = rand.nextInt(this.schemaRegistryUrls.length);
        return new URL(this.schemaRegistryUrls[randomInteger] + reference);
    }

    protected String[] parseSchemaRegistryUrls(String schemaConfig) {
        return schemaConfig.split(",");
    }

    private static class MD5AvroSchemaMap {
        private List<byte[]> md5s = new ArrayList<byte[]>();
        private List<Schema> schemas = new ArrayList<Schema>();

        private MD5AvroSchemaMap() {
        }

        private Schema getSchema(byte[] md5ForSchema) {
            for (int i = 0; i < this.md5s.size(); ++i) {
                if (!Arrays.equals(this.md5s.get(i), md5ForSchema)) continue;
                return this.schemas.get(i);
            }
            return null;
        }

        private void addSchema(byte[] md5, Schema schema) {
            this.md5s.add(Arrays.copyOf(md5, md5.length));
            this.schemas.add(schema);
        }
    }

    private static class SchemaFetcher
    implements Callable<Boolean> {
        private Schema _schema;
        private URL url;
        private boolean _isSuccessful = false;

        SchemaFetcher(URL url) {
            this.url = url;
        }

        @Override
        public Boolean call() throws Exception {
            try {
                URLConnection conn = this.url.openConnection();
                conn.setConnectTimeout(15000);
                conn.setReadTimeout(15000);
                LOGGER.info("Fetching schema using url {}", (Object)this.url.toString());
                StringBuilder queryResp = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));){
                    String line = reader.readLine();
                    while (line != null) {
                        queryResp.append(line);
                        line = reader.readLine();
                    }
                }
                this._schema = Schema.parse((String)queryResp.toString());
                LOGGER.info("Schema fetch succeeded on url {}", (Object)this.url.toString());
                return Boolean.TRUE;
            }
            catch (Exception e) {
                LOGGER.warn("Caught exception while fetching schema", (Throwable)e);
                return Boolean.FALSE;
            }
        }

        public Schema getSchema() {
            return this._schema;
        }
    }
}

