/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaBrokerWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaBrokerWrapper.class);
    private final Object _kafkaBroker;

    public KafkaBrokerWrapper(Object kafkaBroker) {
        this._kafkaBroker = kafkaBroker;
    }

    public String host() {
        if (this._kafkaBroker != null) {
            try {
                Method method = this._kafkaBroker.getClass().getMethod("host", new Class[0]);
                return (String)method.invoke(this._kafkaBroker, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Failed to get host() method from KafkaBroker Object: {}", this._kafkaBroker, (Object)e);
            }
        }
        return "";
    }

    public int port() {
        if (this._kafkaBroker != null) {
            try {
                Method method = this._kafkaBroker.getClass().getMethod("port", new Class[0]);
                return (Integer)method.invoke(this._kafkaBroker, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Failed to get port() method from KafkaBroker Object: {}", this._kafkaBroker, (Object)e);
            }
        }
        return 0;
    }

    public String toString() {
        return this.host() + ":" + this.port();
    }
}

