/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kafka.consumer.Consumer;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;
import kafka.javaapi.consumer.ConsumerConnector;
import org.apache.pinot.$internal.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.pinot.$internal.org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka.ConsumerAndIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka.KafkaHighLevelStreamConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaConsumerManager.class);
    private static final Long IN_USE = -1L;
    private static final long CONSUMER_SHUTDOWN_DELAY_MILLIS = TimeUnit.SECONDS.toMillis(60L);
    private static final Map<ImmutableTriple<String, String, String>, ConsumerAndIterator> CONSUMER_AND_ITERATOR_FOR_CONFIG_KEY = new HashMap<ImmutableTriple<String, String, String>, ConsumerAndIterator>();
    private static final IdentityHashMap<ConsumerAndIterator, Long> CONSUMER_RELEASE_TIME = new IdentityHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConsumerAndIterator acquireConsumerAndIteratorForConfig(KafkaHighLevelStreamConfig kafkaHighLevelStreamConfig) {
        ImmutableTriple<String, String, String> configKey = new ImmutableTriple<String, String, String>(kafkaHighLevelStreamConfig.getKafkaTopicName(), kafkaHighLevelStreamConfig.getGroupId(), kafkaHighLevelStreamConfig.getZkBrokerUrl());
        Class<KafkaConsumerManager> clazz = KafkaConsumerManager.class;
        synchronized (KafkaConsumerManager.class) {
            if (CONSUMER_AND_ITERATOR_FOR_CONFIG_KEY.containsKey(configKey)) {
                ConsumerAndIterator consumerAndIterator = CONSUMER_AND_ITERATOR_FOR_CONFIG_KEY.get(configKey);
                if (CONSUMER_RELEASE_TIME.get(consumerAndIterator).equals(IN_USE)) {
                    throw new RuntimeException("Consumer/iterator " + consumerAndIterator.getId() + " already in use!");
                }
                LOGGER.info("Reusing kafka consumer/iterator with id {}", (Object)consumerAndIterator.getId());
                CONSUMER_RELEASE_TIME.put(consumerAndIterator, IN_USE);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return consumerAndIterator;
            }
            LOGGER.info("Creating new kafka consumer and iterator for topic {}", (Object)kafkaHighLevelStreamConfig.getKafkaTopicName());
            ConsumerConnector consumer = Consumer.createJavaConsumerConnector((ConsumerConfig)kafkaHighLevelStreamConfig.getKafkaConsumerConfig());
            ConsumerIterator iterator = ((KafkaStream)((List)consumer.createMessageStreams(kafkaHighLevelStreamConfig.getTopicMap(1)).get(kafkaHighLevelStreamConfig.getKafkaTopicName())).get(0)).iterator();
            ConsumerAndIterator consumerAndIterator = new ConsumerAndIterator(consumer, (ConsumerIterator<byte[], byte[]>)iterator);
            CONSUMER_AND_ITERATOR_FOR_CONFIG_KEY.put(configKey, consumerAndIterator);
            CONSUMER_RELEASE_TIME.put(consumerAndIterator, IN_USE);
            LOGGER.info("Created consumer/iterator with id {} for topic {}", (Object)consumerAndIterator.getId(), (Object)kafkaHighLevelStreamConfig.getKafkaTopicName());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return consumerAndIterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseConsumerAndIterator(final ConsumerAndIterator consumerAndIterator) {
        Class<KafkaConsumerManager> clazz = KafkaConsumerManager.class;
        synchronized (KafkaConsumerManager.class) {
            final long releaseTime = System.currentTimeMillis() + CONSUMER_SHUTDOWN_DELAY_MILLIS;
            CONSUMER_RELEASE_TIME.put(consumerAndIterator, releaseTime);
            LOGGER.info("Marking consumer/iterator with id {} for release at {}", (Object)consumerAndIterator.getId(), (Object)releaseTime);
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Uninterruptibles.sleepUninterruptibly(CONSUMER_SHUTDOWN_DELAY_MILLIS, TimeUnit.MILLISECONDS);
                        Class<KafkaConsumerManager> clazz = KafkaConsumerManager.class;
                        synchronized (KafkaConsumerManager.class) {
                            LOGGER.info("Executing release check for consumer/iterator {} at {}, scheduled at ", new Object[]{consumerAndIterator.getId(), System.currentTimeMillis(), releaseTime});
                            Iterator configIterator = CONSUMER_AND_ITERATOR_FOR_CONFIG_KEY.entrySet().iterator();
                            while (configIterator.hasNext()) {
                                Map.Entry entry = configIterator.next();
                                ConsumerAndIterator consumerAndIterator2 = (ConsumerAndIterator)entry.getValue();
                                Long releaseTime2 = (Long)CONSUMER_RELEASE_TIME.get(consumerAndIterator2);
                                if (!releaseTime2.equals(IN_USE) && releaseTime2 < System.currentTimeMillis()) {
                                    LOGGER.info("Releasing consumer/iterator {}", (Object)consumerAndIterator2.getId());
                                    try {
                                        consumerAndIterator2.getConsumer().shutdown();
                                    }
                                    catch (Exception e) {
                                        LOGGER.warn("Caught exception while shutting down Kafka consumer with id {}", (Object)consumerAndIterator2.getId(), (Object)e);
                                    }
                                    configIterator.remove();
                                    CONSUMER_RELEASE_TIME.remove(consumerAndIterator2);
                                    continue;
                                }
                                LOGGER.info("Not releasing consumer/iterator {}, it has been reacquired", (Object)consumerAndIterator2.getId());
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Caught exception in release of consumer/iterator {}", (Object)e, (Object)consumerAndIterator);
                    }
                    {
                        return;
                    }
                }
            }.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllConsumers() {
        try {
            Class<KafkaConsumerManager> clazz = KafkaConsumerManager.class;
            synchronized (KafkaConsumerManager.class) {
                LOGGER.info("Trying to shutdown all the kafka consumers");
                Iterator<ConsumerAndIterator> consumerIterator = CONSUMER_AND_ITERATOR_FOR_CONFIG_KEY.values().iterator();
                while (consumerIterator.hasNext()) {
                    ConsumerAndIterator consumerAndIterator = consumerIterator.next();
                    LOGGER.info("Trying to shutdown consumer/iterator {}", (Object)consumerAndIterator.getId());
                    try {
                        consumerAndIterator.getConsumer().shutdown();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Caught exception while shutting down Kafka consumer with id {}", (Object)consumerAndIterator.getId(), (Object)e);
                    }
                    consumerIterator.remove();
                }
                CONSUMER_AND_ITERATOR_FOR_CONFIG_KEY.clear();
                CONSUMER_RELEASE_TIME.clear();
                // ** MonitorExit[var0] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            LOGGER.warn("Caught exception during shutting down all kafka consumers", (Throwable)e);
        }
        {
            return;
        }
    }
}

