/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kafka.consumer.ConsumerConfig;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka.KafkaStreamConfigProperties;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConfigProperties;
import org.apache.pinot.common.metadata.instance.InstanceZKMetadata;
import org.apache.pinot.common.utils.EqualityUtils;

public class KafkaHighLevelStreamConfig {
    private static final String DEFAULT_ZK_SESSION_TIMEOUT_MS = "30000";
    private static final String DEFAULT_ZK_CONNECTION_TIMEOUT_MS = "10000";
    private static final String DEFAULT_ZK_SYNC_TIME = "2000";
    private static final String DEFAULT_REBALANCE_MAX_RETRIES = "30";
    private static final String DEFAULT_REBALANCE_BACKOFF_MS = "2000";
    private static final String DEFAULT_AUTO_COMMIT_ENABLE = "false";
    private static final Map<String, String> defaultProps = new HashMap<String, String>();
    private String _kafkaTopicName;
    private String _groupId;
    private String _zkBrokerUrl;
    private Map<String, String> _kafkaConsumerProperties;

    public KafkaHighLevelStreamConfig(StreamConfig streamConfig, String tableName, InstanceZKMetadata instanceZKMetadata) {
        Map<String, String> streamConfigMap = streamConfig.getStreamConfigsMap();
        this._kafkaTopicName = streamConfig.getTopicName();
        String hlcZkBrokerUrlKey = KafkaStreamConfigProperties.constructStreamProperty("kafka.hlc.zk.connect.string");
        this._zkBrokerUrl = streamConfigMap.get(hlcZkBrokerUrlKey);
        Preconditions.checkNotNull(this._zkBrokerUrl, "Must specify zk broker connect string " + hlcZkBrokerUrlKey + " in high level kafka consumer");
        this._groupId = instanceZKMetadata.getGroupId(tableName);
        this._kafkaConsumerProperties = new HashMap<String, String>();
        String kafkaConsumerPropertyPrefix = KafkaStreamConfigProperties.constructStreamProperty("kafka.consumer.prop");
        for (String key : streamConfigMap.keySet()) {
            if (!key.startsWith(kafkaConsumerPropertyPrefix)) continue;
            this._kafkaConsumerProperties.put(StreamConfigProperties.getPropertySuffix(key, kafkaConsumerPropertyPrefix), streamConfigMap.get(key));
        }
    }

    public String getKafkaTopicName() {
        return this._kafkaTopicName;
    }

    public Map<String, Integer> getTopicMap(int numThreads) {
        HashMap<String, Integer> topicCountMap = new HashMap<String, Integer>();
        topicCountMap.put(this._kafkaTopicName, numThreads);
        return topicCountMap;
    }

    public String getGroupId() {
        return this._groupId;
    }

    public String getZkBrokerUrl() {
        return this._zkBrokerUrl;
    }

    public Map<String, String> getKafkaConsumerProperties() {
        return this._kafkaConsumerProperties;
    }

    public ConsumerConfig getKafkaConsumerConfig() {
        Properties props = new Properties();
        for (String key : defaultProps.keySet()) {
            props.put(key, defaultProps.get(key));
        }
        for (String key : this._kafkaConsumerProperties.keySet()) {
            props.put(key, this._kafkaConsumerProperties.get(key));
        }
        props.put("group.id", this._groupId);
        props.put("zookeeper.connect", this._zkBrokerUrl);
        return new ConsumerConfig(props);
    }

    public String toString() {
        return "KafkaHighLevelStreamConfig{_kafkaTopicName='" + this._kafkaTopicName + '\'' + ", _groupId='" + this._groupId + '\'' + ", _zkBrokerUrl='" + this._zkBrokerUrl + '\'' + ", _kafkaConsumerProperties=" + this._kafkaConsumerProperties + '}';
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        KafkaHighLevelStreamConfig that = (KafkaHighLevelStreamConfig)o;
        return EqualityUtils.isEqual(this._kafkaTopicName, that._kafkaTopicName) && EqualityUtils.isEqual(this._groupId, that._groupId) && EqualityUtils.isEqual(this._zkBrokerUrl, that._zkBrokerUrl) && EqualityUtils.isEqual(this._kafkaConsumerProperties, that._kafkaConsumerProperties);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._kafkaTopicName);
        result = EqualityUtils.hashCodeOf(result, this._groupId);
        result = EqualityUtils.hashCodeOf(result, this._zkBrokerUrl);
        result = EqualityUtils.hashCodeOf(result, this._kafkaConsumerProperties);
        return result;
    }

    static {
        defaultProps.put("zookeeper.session.timeout.ms", DEFAULT_ZK_SESSION_TIMEOUT_MS);
        defaultProps.put("zookeeper.connection.timeout.ms", DEFAULT_ZK_CONNECTION_TIMEOUT_MS);
        defaultProps.put("zookeeper.sync.time.ms", "2000");
        defaultProps.put("rebalance.max.retries", DEFAULT_REBALANCE_MAX_RETRIES);
        defaultProps.put("rebalance.backoff.ms", "2000");
        defaultProps.put("auto.commit.enable", DEFAULT_AUTO_COMMIT_ENABLE);
    }
}

