/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka;

import java.util.Map;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.lang.StringUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka.KafkaStreamConfigProperties;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConfig;
import org.apache.pinot.common.utils.EqualityUtils;

public class KafkaLowLevelStreamConfig {
    private String _kafkaTopicName;
    private String _bootstrapHosts;
    private int _kafkaBufferSize;
    private int _kafkaSocketTimeout;

    public KafkaLowLevelStreamConfig(StreamConfig streamConfig) {
        Map<String, String> streamConfigMap = streamConfig.getStreamConfigsMap();
        this._kafkaTopicName = streamConfig.getTopicName();
        String llcBrokerListKey = KafkaStreamConfigProperties.constructStreamProperty("kafka.broker.list");
        String llcBufferKey = KafkaStreamConfigProperties.constructStreamProperty("kafka.buffer.size");
        String llcTimeoutKey = KafkaStreamConfigProperties.constructStreamProperty("kafka.socket.timeout");
        this._bootstrapHosts = streamConfigMap.get(llcBrokerListKey);
        this._kafkaBufferSize = this.getIntConfigWithDefault(streamConfigMap, llcBufferKey, 512000);
        this._kafkaSocketTimeout = this.getIntConfigWithDefault(streamConfigMap, llcTimeoutKey, 10000);
        Preconditions.checkNotNull(this._bootstrapHosts, "Must specify kafka brokers list " + llcBrokerListKey + " in case of low level kafka consumer");
    }

    public String getKafkaTopicName() {
        return this._kafkaTopicName;
    }

    public String getBootstrapHosts() {
        return this._bootstrapHosts;
    }

    public int getKafkaBufferSize() {
        return this._kafkaBufferSize;
    }

    public int getKafkaSocketTimeout() {
        return this._kafkaSocketTimeout;
    }

    private int getIntConfigWithDefault(Map<String, String> configMap, String key, int defaultValue) {
        String stringValue = configMap.get(key);
        try {
            if (StringUtils.isNotEmpty(stringValue)) {
                return Integer.parseInt(stringValue);
            }
            return defaultValue;
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public String toString() {
        return "KafkaLowLevelStreamConfig{_kafkaTopicName='" + this._kafkaTopicName + '\'' + ", _bootstrapHosts='" + this._bootstrapHosts + '\'' + ", _kafkaBufferSize='" + this._kafkaBufferSize + '\'' + ", _kafkaSocketTimeout='" + this._kafkaSocketTimeout + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        KafkaLowLevelStreamConfig that = (KafkaLowLevelStreamConfig)o;
        return EqualityUtils.isEqual(this._kafkaTopicName, that._kafkaTopicName) && EqualityUtils.isEqual(this._bootstrapHosts, that._bootstrapHosts) && EqualityUtils.isEqual(this._kafkaBufferSize, that._kafkaBufferSize) && EqualityUtils.isEqual(this._kafkaSocketTimeout, that._kafkaSocketTimeout);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._kafkaTopicName);
        result = EqualityUtils.hashCodeOf(result, this._bootstrapHosts);
        result = EqualityUtils.hashCodeOf(result, this._kafkaBufferSize);
        result = EqualityUtils.hashCodeOf(result, this._kafkaSocketTimeout);
        return result;
    }
}

