/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import kafka.api.FetchRequestBuilder;
import kafka.javaapi.FetchResponse;
import kafka.javaapi.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import org.apache.pinot.$internal.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.$internal.com.google.common.collect.Iterables;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka.KafkaConnectionHandler;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka.KafkaSimpleConsumerFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka.KafkaSimpleConsumerFactoryImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka.SimpleConsumerMessageBatch;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.MessageBatch;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.PartitionLevelConsumer;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPartitionLevelConsumer
extends KafkaConnectionHandler
implements PartitionLevelConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaPartitionLevelConsumer.class);

    public KafkaPartitionLevelConsumer(String clientId, StreamConfig streamConfig, int partition) {
        super(clientId, streamConfig, partition, new KafkaSimpleConsumerFactoryImpl());
    }

    @VisibleForTesting
    public KafkaPartitionLevelConsumer(String clientId, StreamConfig streamConfig, int partition, KafkaSimpleConsumerFactory kafkaSimpleConsumerFactory) {
        super(clientId, streamConfig, partition, kafkaSimpleConsumerFactory);
    }

    @Override
    public synchronized MessageBatch fetchMessages(long startOffset, long endOffset, int timeoutMillis) throws TimeoutException {
        long connectEndTime = System.currentTimeMillis() + this._connectTimeoutMillis;
        while (this._currentState.getStateValue() != KafkaConnectionHandler.ConsumerState.CONNECTED_TO_PARTITION_LEADER && System.currentTimeMillis() < connectEndTime) {
            this._currentState.process();
        }
        if (this._currentState.getStateValue() != KafkaConnectionHandler.ConsumerState.CONNECTED_TO_PARTITION_LEADER && connectEndTime <= System.currentTimeMillis()) {
            throw new TimeoutException();
        }
        FetchResponse fetchResponse = this._simpleConsumer.fetch(new FetchRequestBuilder().minBytes(100000).maxWait(timeoutMillis).addFetch(this._topic, this._partition, startOffset, 500000).build());
        if (!fetchResponse.hasError()) {
            Iterable<MessageAndOffset> messageAndOffsetIterable = this.buildOffsetFilteringIterable(fetchResponse.messageSet(this._topic, this._partition), startOffset, endOffset);
            return new SimpleConsumerMessageBatch(messageAndOffsetIterable);
        }
        throw this.exceptionForKafkaErrorCode(fetchResponse.errorCode(this._topic, this._partition));
    }

    private Iterable<MessageAndOffset> buildOffsetFilteringIterable(ByteBufferMessageSet messageAndOffsets, long startOffset, long endOffset) {
        return Iterables.filter(messageAndOffsets, input -> {
            if (input == null || input.offset() < startOffset || endOffset <= input.offset() && endOffset != -1L) {
                return false;
            }
            if (!input.message().isValid()) {
                LOGGER.warn("Discarded message with invalid checksum in partition {} of topic {}", (Object)this._partition, (Object)this._topic);
                return false;
            }
            return true;
        });
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

