/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka;

import kafka.consumer.ConsumerIterator;
import kafka.javaapi.consumer.ConsumerConnector;
import org.apache.pinot.$internal.com.yammer.metrics.core.Meter;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka.ConsumerAndIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka.KafkaConsumerManager;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka.KafkaHighLevelStreamConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamDecoderProvider;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamLevelConsumer;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamMessageDecoder;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.metadata.instance.InstanceZKMetadata;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStreamLevelConsumer
implements StreamLevelConsumer {
    private StreamMessageDecoder _messageDecoder;
    private Logger INSTANCE_LOGGER;
    private String _clientId;
    private String _tableAndStreamName;
    private StreamConfig _streamConfig;
    private KafkaHighLevelStreamConfig _kafkaHighLevelStreamConfig;
    private ConsumerConnector consumer;
    private ConsumerIterator<byte[], byte[]> kafkaIterator;
    private ConsumerAndIterator consumerAndIterator;
    private long lastLogTime = 0L;
    private long lastCount = 0L;
    private long currentCount = 0L;
    private ServerMetrics _serverMetrics;
    private Meter tableAndStreamRowsConsumed = null;
    private Meter tableRowsConsumed = null;

    public KafkaStreamLevelConsumer(String clientId, String tableName, StreamConfig streamConfig, Schema schema, InstanceZKMetadata instanceZKMetadata, ServerMetrics serverMetrics) {
        this._clientId = clientId;
        this._streamConfig = streamConfig;
        this._kafkaHighLevelStreamConfig = new KafkaHighLevelStreamConfig(streamConfig, tableName, instanceZKMetadata);
        this._serverMetrics = serverMetrics;
        this._messageDecoder = StreamDecoderProvider.create(streamConfig, schema);
        this._tableAndStreamName = tableName + "-" + streamConfig.getTopicName();
        this.INSTANCE_LOGGER = LoggerFactory.getLogger((String)(KafkaStreamLevelConsumer.class.getName() + "_" + tableName + "_" + streamConfig.getTopicName()));
    }

    @Override
    public void start() throws Exception {
        this.consumerAndIterator = KafkaConsumerManager.acquireConsumerAndIteratorForConfig(this._kafkaHighLevelStreamConfig);
        this.kafkaIterator = this.consumerAndIterator.getIterator();
        this.consumer = this.consumerAndIterator.getConsumer();
    }

    @Override
    public GenericRow next(GenericRow destination) {
        if (this.kafkaIterator.hasNext()) {
            try {
                destination = this._messageDecoder.decode(this.kafkaIterator.next().message(), destination);
                this.tableAndStreamRowsConsumed = this._serverMetrics.addMeteredTableValue(this._tableAndStreamName, ServerMeter.REALTIME_ROWS_CONSUMED, 1L, this.tableAndStreamRowsConsumed);
                this.tableRowsConsumed = this._serverMetrics.addMeteredGlobalValue(ServerMeter.REALTIME_ROWS_CONSUMED, 1L, this.tableRowsConsumed);
                ++this.currentCount;
                long now = System.currentTimeMillis();
                if (now - this.lastLogTime > 60000L || this.currentCount - this.lastCount >= 100000L) {
                    if (this.lastCount == 0L) {
                        this.INSTANCE_LOGGER.info("Consumed {} events from kafka stream {}", (Object)this.currentCount, (Object)this._streamConfig.getTopicName());
                    } else {
                        this.INSTANCE_LOGGER.info("Consumed {} events from kafka stream {} (rate:{}/s)", new Object[]{this.currentCount - this.lastCount, this._streamConfig.getTopicName(), Float.valueOf((float)(this.currentCount - this.lastCount) * 1000.0f / (float)(now - this.lastLogTime))});
                    }
                    this.lastCount = this.currentCount;
                    this.lastLogTime = now;
                }
                return destination;
            }
            catch (Exception e) {
                this.INSTANCE_LOGGER.warn("Caught exception while consuming events", (Throwable)e);
                this._serverMetrics.addMeteredTableValue(this._tableAndStreamName, ServerMeter.REALTIME_CONSUMPTION_EXCEPTIONS, 1L);
                this._serverMetrics.addMeteredGlobalValue(ServerMeter.REALTIME_CONSUMPTION_EXCEPTIONS, 1L);
                throw e;
            }
        }
        return null;
    }

    @Override
    public void commit() {
        this.consumer.commitOffsets();
        this._serverMetrics.addMeteredTableValue(this._tableAndStreamName, ServerMeter.REALTIME_OFFSET_COMMITS, 1L);
        this._serverMetrics.addMeteredGlobalValue(ServerMeter.REALTIME_OFFSET_COMMITS, 1L);
    }

    @Override
    public void shutdown() throws Exception {
        if (this.consumerAndIterator != null) {
            this.kafkaIterator = null;
            this.consumer = null;
            KafkaConsumerManager.releaseConsumerAndIterator(this.consumerAndIterator);
            this.consumerAndIterator = null;
        }
    }
}

