/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.segment;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.segment.RealtimeSegmentAssignmentStrategy;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.common.partition.PartitionAssignment;
import org.apache.pinot.common.utils.LLCSegmentName;

public class ConsumingSegmentAssignmentStrategy
implements RealtimeSegmentAssignmentStrategy {
    @Override
    public Map<String, List<String>> assign(Collection<String> newSegments, PartitionAssignment partitionAssignment) throws InvalidConfigException {
        HashMap<String, List<String>> segmentAssignment = new HashMap<String, List<String>>(newSegments.size());
        for (String segmentName : newSegments) {
            if (!LLCSegmentName.isLowLevelConsumerSegmentName(segmentName)) continue;
            LLCSegmentName llcSegmentName = new LLCSegmentName(segmentName);
            int partitionId = llcSegmentName.getPartitionId();
            List<String> instancesListForPartition = partitionAssignment.getInstancesListForPartition(String.valueOf(partitionId));
            if (instancesListForPartition == null) {
                throw new InvalidConfigException("No partition assignment " + partitionId + " found for segment " + segmentName);
            }
            segmentAssignment.put(segmentName, instancesListForPartition);
        }
        return segmentAssignment;
    }
}

