/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream;

import java.util.concurrent.Callable;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConsumerFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConsumerFactoryProvider;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamMetadataProvider;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.TransientConsumerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionCountFetcher
implements Callable<Boolean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionCountFetcher.class);
    private int _partitionCount = -1;
    private final StreamConfig _streamConfig;
    private StreamConsumerFactory _streamConsumerFactory;
    private Exception _exception;
    private final String _topicName;

    public PartitionCountFetcher(StreamConfig streamConfig) {
        this._streamConfig = streamConfig;
        this._streamConsumerFactory = StreamConsumerFactoryProvider.create(this._streamConfig);
        this._topicName = streamConfig.getTopicName();
    }

    public int getPartitionCount() {
        return this._partitionCount;
    }

    public Exception getException() {
        return this._exception;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean call() throws Exception {
        String clientId = PartitionCountFetcher.class.getSimpleName() + "-" + this._topicName;
        try (StreamMetadataProvider streamMetadataProvider = this._streamConsumerFactory.createStreamMetadataProvider(clientId);){
            this._partitionCount = streamMetadataProvider.fetchPartitionCount(5000L);
            if (this._exception != null) {
                LOGGER.info("Successfully retrieved partition count as {} for topic {}", (Object)this._partitionCount, (Object)this._topicName);
            }
            Boolean bl = Boolean.TRUE;
            return bl;
        }
        catch (TransientConsumerException e) {
            LOGGER.warn("Could not get partition count for topic {}", (Object)this._topicName, (Object)e);
            this._exception = e;
            return Boolean.FALSE;
        }
        catch (Exception e) {
            LOGGER.warn("Could not get partition count for topic {}", (Object)this._topicName, (Object)e);
            this._exception = e;
            throw e;
        }
    }
}

