/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.OffsetCriteria;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConfigProperties;
import org.apache.pinot.common.utils.DataSize;
import org.apache.pinot.common.utils.EqualityUtils;
import org.apache.pinot.common.utils.time.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamConfig.class);
    private static final int DEFAULT_FLUSH_THRESHOLD_ROWS = 5000000;
    private static final long DEFAULT_FLUSH_THRESHOLD_TIME = TimeUnit.MILLISECONDS.convert(6L, TimeUnit.HOURS);
    private static final long DEFAULT_DESIRED_SEGMENT_SIZE_BYTES = 0xC800000L;
    private static final String DEFAULT_CONSUMER_FACTORY_CLASS_NAME_STRING = .KafkaConsumerFactory.class.getName();
    protected static final long DEFAULT_STREAM_CONNECTION_TIMEOUT_MILLIS = 30000L;
    protected static final int DEFAULT_STREAM_FETCH_TIMEOUT_MILLIS = 5000;
    protected static final String SIMPLE_CONSUMER_TYPE_STRING = "simple";
    private final String _type;
    private final String _topicName;
    private final List<ConsumerType> _consumerTypes = new ArrayList<ConsumerType>();
    private final String _consumerFactoryClassName;
    private final OffsetCriteria _offsetCriteria;
    private final String _decoderClass;
    private final Map<String, String> _decoderProperties = new HashMap<String, String>();
    private final long _connectionTimeoutMillis;
    private final int _fetchTimeoutMillis;
    private final int _flushThresholdRows;
    private final long _flushThresholdTimeMillis;
    private final long _flushSegmentDesiredSizeBytes;
    private final String _groupId;
    private final Map<String, String> _streamConfigMap = new HashMap<String, String>();

    public StreamConfig(Map<String, String> streamConfigMap) {
        this._type = streamConfigMap.get("streamType");
        Preconditions.checkNotNull(this._type, "Stream type cannot be null");
        String topicNameKey = StreamConfigProperties.constructStreamProperty(this._type, "topic.name");
        this._topicName = streamConfigMap.get(topicNameKey);
        Preconditions.checkNotNull(this._topicName, "Stream topic name " + topicNameKey + " cannot be null");
        String consumerTypesKey = StreamConfigProperties.constructStreamProperty(this._type, "consumer.type");
        String consumerTypes = streamConfigMap.get(consumerTypesKey);
        Preconditions.checkNotNull(consumerTypes, "Must specify at least one consumer type " + consumerTypesKey);
        for (String consumerType : consumerTypes.split(",")) {
            if (consumerType.equals(SIMPLE_CONSUMER_TYPE_STRING)) {
                consumerType = ConsumerType.LOWLEVEL.toString();
            }
            this._consumerTypes.add(ConsumerType.valueOf(consumerType.toUpperCase()));
        }
        String consumerFactoryClassKey = StreamConfigProperties.constructStreamProperty(this._type, "consumer.factory.class.name");
        this._consumerFactoryClassName = streamConfigMap.containsKey(consumerFactoryClassKey) ? streamConfigMap.get(consumerFactoryClassKey) : DEFAULT_CONSUMER_FACTORY_CLASS_NAME_STRING;
        LOGGER.info("Stream type: {}, name: {}, consumer types: {}, consumer factory: {}", new Object[]{this._type, this._topicName, this._consumerTypes, this._consumerFactoryClassName});
        String offsetCriteriaKey = StreamConfigProperties.constructStreamProperty(this._type, "consumer.prop.auto.offset.reset");
        String offsetCriteriaValue = streamConfigMap.get(offsetCriteriaKey);
        this._offsetCriteria = offsetCriteriaValue != null ? new OffsetCriteria.OffsetCriteriaBuilder().withOffsetString(offsetCriteriaValue) : new OffsetCriteria.OffsetCriteriaBuilder().withOffsetLargest();
        String decoderClassKey = StreamConfigProperties.constructStreamProperty(this._type, "decoder.class.name");
        this._decoderClass = streamConfigMap.get(decoderClassKey);
        Preconditions.checkNotNull(this._decoderClass, "Must specify decoder class name " + decoderClassKey);
        String streamDecoderPropPrefix = StreamConfigProperties.constructStreamProperty(this._type, "decoder.prop");
        for (String key : streamConfigMap.keySet()) {
            if (!key.startsWith(streamDecoderPropPrefix)) continue;
            this._decoderProperties.put(StreamConfigProperties.getPropertySuffix(key, streamDecoderPropPrefix), streamConfigMap.get(key));
        }
        long connectionTimeoutMillis = 30000L;
        String connectionTimeoutKey = StreamConfigProperties.constructStreamProperty(this._type, "connection.timeout.millis");
        String connectionTimeoutValue = streamConfigMap.get(connectionTimeoutKey);
        if (connectionTimeoutValue != null) {
            try {
                connectionTimeoutMillis = Long.parseLong(connectionTimeoutValue);
            }
            catch (Exception e) {
                LOGGER.warn("Caught exception while parsing the connection timeout, defaulting to {} ms", (Object)e, (Object)30000L);
            }
        }
        this._connectionTimeoutMillis = connectionTimeoutMillis;
        int fetchTimeoutMillis = 5000;
        String fetchTimeoutKey = StreamConfigProperties.constructStreamProperty(this._type, "fetch.timeout.millis");
        String fetchTimeoutValue = streamConfigMap.get(fetchTimeoutKey);
        if (fetchTimeoutValue != null) {
            try {
                fetchTimeoutMillis = Integer.parseInt(fetchTimeoutValue);
            }
            catch (Exception e) {
                LOGGER.warn("Caught exception while parsing the fetch timeout, defaulting to {} ms", (Object)5000, (Object)e);
            }
        }
        this._fetchTimeoutMillis = fetchTimeoutMillis;
        int flushThresholdRows = 5000000;
        String flushThresholdRowsValue = streamConfigMap.get("realtime.segment.flush.threshold.size");
        if (flushThresholdRowsValue != null) {
            try {
                flushThresholdRows = Integer.parseInt(flushThresholdRowsValue);
            }
            catch (Exception e) {
                LOGGER.warn("Caught exception when parsing flush threshold rows {}:{}, defaulting to {}", new Object[]{"realtime.segment.flush.threshold.size", flushThresholdRowsValue, 5000000, e});
            }
        }
        this._flushThresholdRows = flushThresholdRows;
        long flushThresholdTime = DEFAULT_FLUSH_THRESHOLD_TIME;
        String flushThresholdTimeValue = streamConfigMap.get("realtime.segment.flush.threshold.time");
        if (flushThresholdTimeValue != null) {
            try {
                flushThresholdTime = TimeUtils.convertPeriodToMillis(flushThresholdTimeValue);
            }
            catch (Exception e) {
                try {
                    flushThresholdTime = Long.parseLong(flushThresholdTimeValue);
                }
                catch (Exception e1) {
                    LOGGER.warn("Caught exception when converting flush threshold period to millis {}:{}, defaulting to {}", new Object[]{"realtime.segment.flush.threshold.time", flushThresholdTimeValue, DEFAULT_FLUSH_THRESHOLD_TIME, e});
                }
            }
        }
        this._flushThresholdTimeMillis = flushThresholdTime;
        long flushDesiredSize = -1L;
        String flushSegmentDesiredSizeValue = streamConfigMap.get("realtime.segment.flush.desired.size");
        if (flushSegmentDesiredSizeValue != null) {
            flushDesiredSize = DataSize.toBytes(flushSegmentDesiredSizeValue);
        }
        this._flushSegmentDesiredSizeBytes = flushDesiredSize > 0L ? flushDesiredSize : 0xC800000L;
        String groupIdKey = StreamConfigProperties.constructStreamProperty(this._type, "hlc.group.id");
        this._groupId = streamConfigMap.get(groupIdKey);
        this._streamConfigMap.putAll(streamConfigMap);
    }

    public String getType() {
        return this._type;
    }

    public String getTopicName() {
        return this._topicName;
    }

    public List<ConsumerType> getConsumerTypes() {
        return this._consumerTypes;
    }

    public boolean hasHighLevelConsumerType() {
        return this._consumerTypes.contains((Object)ConsumerType.HIGHLEVEL);
    }

    public boolean hasLowLevelConsumerType() {
        return this._consumerTypes.contains((Object)ConsumerType.LOWLEVEL);
    }

    public String getConsumerFactoryClassName() {
        return this._consumerFactoryClassName;
    }

    public OffsetCriteria getOffsetCriteria() {
        return this._offsetCriteria;
    }

    public long getConnectionTimeoutMillis() {
        return this._connectionTimeoutMillis;
    }

    public int getFetchTimeoutMillis() {
        return this._fetchTimeoutMillis;
    }

    public int getFlushThresholdRows() {
        return this._flushThresholdRows;
    }

    public static int getDefaultFlushThresholdRows() {
        return 5000000;
    }

    public long getFlushThresholdTimeMillis() {
        return this._flushThresholdTimeMillis;
    }

    public static long getDefaultFlushThresholdTimeMillis() {
        return DEFAULT_FLUSH_THRESHOLD_TIME;
    }

    public static String getDefaultConsumerFactoryClassName() {
        return DEFAULT_CONSUMER_FACTORY_CLASS_NAME_STRING;
    }

    public long getFlushSegmentDesiredSizeBytes() {
        return this._flushSegmentDesiredSizeBytes;
    }

    public static long getDefaultDesiredSegmentSizeBytes() {
        return 0xC800000L;
    }

    public String getDecoderClass() {
        return this._decoderClass;
    }

    public Map<String, String> getDecoderProperties() {
        return this._decoderProperties;
    }

    public String getGroupId() {
        return this._groupId;
    }

    public Map<String, String> getStreamConfigsMap() {
        return this._streamConfigMap;
    }

    public String toString() {
        return "StreamConfig{_type='" + this._type + '\'' + ", _topicName='" + this._topicName + '\'' + ", _consumerTypes=" + this._consumerTypes + ", _consumerFactoryClassName='" + this._consumerFactoryClassName + '\'' + ", _offsetCriteria='" + this._offsetCriteria + '\'' + ", _connectionTimeoutMillis=" + this._connectionTimeoutMillis + ", _fetchTimeoutMillis=" + this._fetchTimeoutMillis + ", _flushThresholdRows=" + this._flushThresholdRows + ", _flushThresholdTimeMillis=" + this._flushThresholdTimeMillis + ", _flushSegmentDesiredSizeBytes=" + this._flushSegmentDesiredSizeBytes + ", _decoderClass='" + this._decoderClass + '\'' + ", _decoderProperties=" + this._decoderProperties + ", _groupId='" + this._groupId + '}';
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        StreamConfig that = (StreamConfig)o;
        return EqualityUtils.isEqual(this._connectionTimeoutMillis, that._connectionTimeoutMillis) && EqualityUtils.isEqual(this._fetchTimeoutMillis, that._fetchTimeoutMillis) && EqualityUtils.isEqual(this._flushThresholdRows, that._flushThresholdRows) && EqualityUtils.isEqual(this._flushThresholdTimeMillis, that._flushThresholdTimeMillis) && EqualityUtils.isEqual(this._flushSegmentDesiredSizeBytes, that._flushSegmentDesiredSizeBytes) && EqualityUtils.isEqual(this._type, that._type) && EqualityUtils.isEqual(this._topicName, that._topicName) && EqualityUtils.isEqual(this._consumerTypes, that._consumerTypes) && EqualityUtils.isEqual(this._consumerFactoryClassName, that._consumerFactoryClassName) && EqualityUtils.isEqual(this._offsetCriteria, that._offsetCriteria) && EqualityUtils.isEqual(this._decoderClass, that._decoderClass) && EqualityUtils.isEqual(this._decoderProperties, that._decoderProperties) && EqualityUtils.isEqual(this._groupId, that._groupId) && EqualityUtils.isEqual(this._streamConfigMap, that._streamConfigMap);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._type);
        result = EqualityUtils.hashCodeOf(result, this._topicName);
        result = EqualityUtils.hashCodeOf(result, this._consumerTypes);
        result = EqualityUtils.hashCodeOf(result, this._consumerFactoryClassName);
        result = EqualityUtils.hashCodeOf(result, this._offsetCriteria);
        result = EqualityUtils.hashCodeOf(result, this._connectionTimeoutMillis);
        result = EqualityUtils.hashCodeOf(result, this._fetchTimeoutMillis);
        result = EqualityUtils.hashCodeOf(result, this._flushThresholdRows);
        result = EqualityUtils.hashCodeOf(result, this._flushThresholdTimeMillis);
        result = EqualityUtils.hashCodeOf(result, this._flushSegmentDesiredSizeBytes);
        result = EqualityUtils.hashCodeOf(result, this._decoderClass);
        result = EqualityUtils.hashCodeOf(result, this._decoderProperties);
        result = EqualityUtils.hashCodeOf(result, this._groupId);
        result = EqualityUtils.hashCodeOf(result, this._streamConfigMap);
        return result;
    }

    public static enum ConsumerType {
        HIGHLEVEL,
        LOWLEVEL;

    }
}

