/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.creator;

import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer.CompoundTransformer;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.SegmentCreationDataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.SegmentPreIndexStatsCollector;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.StatsCollectorConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats.SegmentPreIndexStatsCollectorImpl;
import org.apache.pinot.common.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordReaderSegmentCreationDataSource
implements SegmentCreationDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordReaderSegmentCreationDataSource.class);
    private final RecordReader _recordReader;

    public RecordReaderSegmentCreationDataSource(RecordReader recordReader) {
        this._recordReader = recordReader;
    }

    @Override
    public SegmentPreIndexStatsCollector gatherStats(StatsCollectorConfig statsCollectorConfig) {
        try {
            CompoundTransformer recordTransformer = CompoundTransformer.getDefaultTransformer(statsCollectorConfig.getSchema());
            SegmentPreIndexStatsCollectorImpl collector = new SegmentPreIndexStatsCollectorImpl(statsCollectorConfig);
            collector.init();
            GenericRow readRow = null;
            while (this._recordReader.hasNext()) {
                GenericRow transformedRow = recordTransformer.transform(this._recordReader.next(readRow = GenericRow.createOrReuseRow(readRow)));
                if (transformedRow == null) continue;
                collector.collectRow(transformedRow);
            }
            collector.build();
            return collector;
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while gathering stats", (Throwable)e);
            Utils.rethrowException(e);
            return null;
        }
    }

    @Override
    public RecordReader getRecordReader() {
        try {
            this._recordReader.rewind();
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while rewinding record reader", (Throwable)e);
            Utils.rethrowException(e);
        }
        return this._recordReader;
    }
}

