/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.creator;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.data.partition.PartitionFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.data.partition.PartitionFunctionFactory;
import org.apache.pinot.common.config.SegmentPartitionConfig;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;

public class StatsCollectorConfig {
    private final Schema _schema;
    private final SegmentPartitionConfig _segmentPartitionConfig;

    public StatsCollectorConfig(@Nonnull Schema schema, SegmentPartitionConfig segmentPartitionConfig) {
        Preconditions.checkNotNull(schema);
        this._schema = schema;
        this._segmentPartitionConfig = segmentPartitionConfig;
    }

    @Nullable
    public FieldSpec getFieldSpecForColumn(String column) {
        return this._schema.getFieldSpecFor(column);
    }

    @Nullable
    public PartitionFunction getPartitionFunction(String column) {
        if (this._segmentPartitionConfig == null) {
            return null;
        }
        String functionName = this._segmentPartitionConfig.getFunctionName(column);
        int numPartitions = this._segmentPartitionConfig.getNumPartitions(column);
        return functionName != null ? PartitionFunctionFactory.getPartitionFunction(functionName, numPartitions) : null;
    }

    public int getNumPartitions(String column) {
        return this._segmentPartitionConfig != null ? this._segmentPartitionConfig.getNumPartitions(column) : -1;
    }

    @Nonnull
    public Schema getSchema() {
        return this._schema;
    }
}

