/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl;

import it.unimi.dsi.fastutil.doubles.Double2IntOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.io.FileUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.io.util.FixedByteValueReaderWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.common.utils.primitive.ByteArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentDictionaryCreator
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentDictionaryCreator.class);
    private final Object _sortedValues;
    private final FieldSpec _fieldSpec;
    private final File _dictionaryFile;
    private Int2IntOpenHashMap _intValueToIndexMap;
    private Long2IntOpenHashMap _longValueToIndexMap;
    private Float2IntOpenHashMap _floatValueToIndexMap;
    private Double2IntOpenHashMap _doubleValueToIndexMap;
    private Object2IntOpenHashMap<String> _stringValueToIndexMap;
    private Object2IntOpenHashMap<ByteArray> _bytesValueToIndexMap;
    private int _numBytesPerEntry = 0;

    public SegmentDictionaryCreator(Object sortedValues, FieldSpec fieldSpec, File indexDir) throws IOException {
        this._sortedValues = sortedValues;
        this._fieldSpec = fieldSpec;
        this._dictionaryFile = new File(indexDir, fieldSpec.getName() + ".dict");
        FileUtils.touch(this._dictionaryFile);
    }

    public void build() throws IOException {
        switch (this._fieldSpec.getDataType()) {
            case INT: {
                int[] sortedInts = (int[])this._sortedValues;
                int numValues = sortedInts.length;
                Preconditions.checkState(numValues > 0);
                this._intValueToIndexMap = new Int2IntOpenHashMap(numValues);
                try (PinotDataBuffer dataBuffer = PinotDataBuffer.mapFile(this._dictionaryFile, false, 0L, (long)numValues * 4L, ByteOrder.BIG_ENDIAN, this.getClass().getSimpleName());
                     FixedByteValueReaderWriter writer = new FixedByteValueReaderWriter(dataBuffer);){
                    for (int i = 0; i < numValues; ++i) {
                        int value = sortedInts[i];
                        this._intValueToIndexMap.put(value, i);
                        writer.writeInt(i, value);
                    }
                }
                LOGGER.info("Created dictionary for INT column: {} with cardinality: {}, range: {} to {}", new Object[]{this._fieldSpec.getName(), numValues, sortedInts[0], sortedInts[numValues - 1]});
                return;
            }
            case LONG: {
                long[] sortedLongs = (long[])this._sortedValues;
                int numValues = sortedLongs.length;
                Preconditions.checkState(numValues > 0);
                this._longValueToIndexMap = new Long2IntOpenHashMap(numValues);
                try (PinotDataBuffer dataBuffer = PinotDataBuffer.mapFile(this._dictionaryFile, false, 0L, (long)numValues * 8L, ByteOrder.BIG_ENDIAN, this.getClass().getSimpleName());
                     FixedByteValueReaderWriter writer = new FixedByteValueReaderWriter(dataBuffer);){
                    for (int i = 0; i < numValues; ++i) {
                        long value = sortedLongs[i];
                        this._longValueToIndexMap.put(value, i);
                        writer.writeLong(i, value);
                    }
                }
                LOGGER.info("Created dictionary for LONG column: {} with cardinality: {}, range: {} to {}", new Object[]{this._fieldSpec.getName(), numValues, sortedLongs[0], sortedLongs[numValues - 1]});
                return;
            }
            case FLOAT: {
                float[] sortedFloats = (float[])this._sortedValues;
                int numValues = sortedFloats.length;
                Preconditions.checkState(numValues > 0);
                this._floatValueToIndexMap = new Float2IntOpenHashMap(numValues);
                try (PinotDataBuffer dataBuffer = PinotDataBuffer.mapFile(this._dictionaryFile, false, 0L, (long)numValues * 4L, ByteOrder.BIG_ENDIAN, this.getClass().getSimpleName());
                     FixedByteValueReaderWriter writer = new FixedByteValueReaderWriter(dataBuffer);){
                    for (int i = 0; i < numValues; ++i) {
                        float value = sortedFloats[i];
                        this._floatValueToIndexMap.put(value, i);
                        writer.writeFloat(i, value);
                    }
                }
                LOGGER.info("Created dictionary for FLOAT column: {} with cardinality: {}, range: {} to {}", new Object[]{this._fieldSpec.getName(), numValues, Float.valueOf(sortedFloats[0]), Float.valueOf(sortedFloats[numValues - 1])});
                return;
            }
            case DOUBLE: {
                double[] sortedDoubles = (double[])this._sortedValues;
                int numValues = sortedDoubles.length;
                Preconditions.checkState(numValues > 0);
                this._doubleValueToIndexMap = new Double2IntOpenHashMap(numValues);
                try (PinotDataBuffer dataBuffer = PinotDataBuffer.mapFile(this._dictionaryFile, false, 0L, (long)numValues * 8L, ByteOrder.BIG_ENDIAN, this.getClass().getSimpleName());
                     FixedByteValueReaderWriter writer = new FixedByteValueReaderWriter(dataBuffer);){
                    for (int i = 0; i < numValues; ++i) {
                        double value = sortedDoubles[i];
                        this._doubleValueToIndexMap.put(value, i);
                        writer.writeDouble(i, value);
                    }
                }
                LOGGER.info("Created dictionary for DOUBLE column: {} with cardinality: {}, range: {} to {}", new Object[]{this._fieldSpec.getName(), numValues, sortedDoubles[0], sortedDoubles[numValues - 1]});
                return;
            }
            case STRING: {
                Object value;
                String[] sortedStrings = (String[])this._sortedValues;
                int numValues = sortedStrings.length;
                Preconditions.checkState(numValues > 0);
                this._stringValueToIndexMap = new Object2IntOpenHashMap(numValues);
                byte[][] sortedStringBytes = new byte[numValues][];
                for (int i = 0; i < numValues; ++i) {
                    value = sortedStrings[i];
                    this._stringValueToIndexMap.put(value, i);
                    byte[] valueBytes = StringUtil.encodeUtf8((String)value);
                    sortedStringBytes[i] = valueBytes;
                    this._numBytesPerEntry = Math.max(this._numBytesPerEntry, valueBytes.length);
                }
                PinotDataBuffer dataBuffer = PinotDataBuffer.mapFile(this._dictionaryFile, false, 0L, (long)numValues * (long)this._numBytesPerEntry, ByteOrder.BIG_ENDIAN, this.getClass().getSimpleName());
                value = null;
                try (FixedByteValueReaderWriter writer2 = new FixedByteValueReaderWriter(dataBuffer);){
                    for (int i = 0; i < numValues; ++i) {
                        byte[] value2 = sortedStringBytes[i];
                        writer2.writeUnpaddedString(i, this._numBytesPerEntry, value2);
                    }
                }
                catch (Throwable writer2) {
                    value = writer2;
                    throw writer2;
                }
                finally {
                    if (dataBuffer != null) {
                        if (value != null) {
                            try {
                                dataBuffer.close();
                            }
                            catch (Throwable writer2) {
                                ((Throwable)value).addSuppressed(writer2);
                            }
                        } else {
                            dataBuffer.close();
                        }
                    }
                }
                LOGGER.info("Created dictionary for STRING column: {} with cardinality: {}, max length in bytes: {}, range: {} to {}", new Object[]{this._fieldSpec.getName(), numValues, this._numBytesPerEntry, sortedStrings[0], sortedStrings[numValues - 1]});
                return;
            }
            case BYTES: {
                ByteArray[] sortedBytes = (ByteArray[])this._sortedValues;
                int numValues = sortedBytes.length;
                Preconditions.checkState(numValues > 0);
                this._bytesValueToIndexMap = new Object2IntOpenHashMap(numValues);
                for (int i = 0; i < numValues; ++i) {
                    ByteArray value = sortedBytes[i];
                    this._bytesValueToIndexMap.put((Object)value, i);
                    this._numBytesPerEntry = Math.max(this._numBytesPerEntry, value.getBytes().length);
                }
                try (PinotDataBuffer dataBuffer = PinotDataBuffer.mapFile(this._dictionaryFile, false, 0L, (long)numValues * (long)this._numBytesPerEntry, ByteOrder.BIG_ENDIAN, this.getClass().getSimpleName());
                     FixedByteValueReaderWriter writer = new FixedByteValueReaderWriter(dataBuffer);){
                    for (int i = 0; i < numValues; ++i) {
                        byte[] value = sortedBytes[i].getBytes();
                        writer.writeUnpaddedString(i, this._numBytesPerEntry, value);
                    }
                }
                LOGGER.info("Created dictionary for BYTES column: {} with cardinality: {}, max length in bytes: {}, range: {} to {}", new Object[]{this._fieldSpec.getName(), numValues, this._numBytesPerEntry, sortedBytes[0], sortedBytes[numValues - 1]});
                return;
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)this._fieldSpec.getDataType()));
    }

    public int getNumBytesPerEntry() {
        return this._numBytesPerEntry;
    }

    public int indexOfSV(Object value) {
        switch (this._fieldSpec.getDataType()) {
            case INT: {
                return this._intValueToIndexMap.get(((Integer)value).intValue());
            }
            case LONG: {
                return this._longValueToIndexMap.get(((Long)value).longValue());
            }
            case FLOAT: {
                return this._floatValueToIndexMap.get(((Float)value).floatValue());
            }
            case DOUBLE: {
                return this._doubleValueToIndexMap.get(((Double)value).doubleValue());
            }
            case STRING: {
                return this._stringValueToIndexMap.getInt(value);
            }
            case BYTES: {
                return this._bytesValueToIndexMap.get((Object)new ByteArray((byte[])value));
            }
        }
        throw new UnsupportedOperationException("Unsupported data type : " + (Object)((Object)this._fieldSpec.getDataType()));
    }

    public int[] indexOfMV(Object value) {
        Object[] multiValues = (Object[])value;
        int[] indexes = new int[multiValues.length];
        switch (this._fieldSpec.getDataType()) {
            case INT: {
                for (int i = 0; i < multiValues.length; ++i) {
                    indexes[i] = this._intValueToIndexMap.get(((Integer)multiValues[i]).intValue());
                }
                break;
            }
            case LONG: {
                for (int i = 0; i < multiValues.length; ++i) {
                    indexes[i] = this._longValueToIndexMap.get(((Long)multiValues[i]).longValue());
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < multiValues.length; ++i) {
                    indexes[i] = this._floatValueToIndexMap.get(((Float)multiValues[i]).floatValue());
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < multiValues.length; ++i) {
                    indexes[i] = this._doubleValueToIndexMap.get(((Double)multiValues[i]).doubleValue());
                }
                break;
            }
            case STRING: {
                for (int i = 0; i < multiValues.length; ++i) {
                    indexes[i] = this._stringValueToIndexMap.getInt(multiValues[i]);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type : " + (Object)((Object)this._fieldSpec.getDataType()));
            }
        }
        Arrays.sort(indexes);
        return indexes;
    }

    @Override
    public void close() {
    }
}

