/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.bloom;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.pinot.$internal.org.apache.pinot.core.bloom.BloomFilter;
import org.apache.pinot.$internal.org.apache.pinot.core.bloom.BloomFilterUtil;
import org.apache.pinot.$internal.org.apache.pinot.core.bloom.SegmentBloomFilterFactory;

public class BloomFilterCreator
implements AutoCloseable {
    private static double DEFAULT_MAX_FALSE_POS_PROBABILITY = 0.05;
    private static int MB_IN_BITS = 0x800000;
    private BloomFilter _bloomFilter;
    private File _bloomFilterFile;

    public BloomFilterCreator(File indexDir, String columnName, int cardinality) {
        this._bloomFilterFile = new File(indexDir, columnName + ".bloom");
        double maxFalsePosProbability = BloomFilterUtil.computeMaxFalsePositiveProbabilityForNumBits(cardinality, MB_IN_BITS, DEFAULT_MAX_FALSE_POS_PROBABILITY);
        this._bloomFilter = SegmentBloomFilterFactory.createSegmentBloomFilter(cardinality, maxFalsePosProbability);
    }

    @Override
    public void close() throws IOException {
        try (DataOutputStream outputStream = new DataOutputStream(new FileOutputStream(this._bloomFilterFile));){
            outputStream.writeInt(this._bloomFilter.getBloomFilterType().getValue());
            outputStream.writeInt(this._bloomFilter.getVersion());
            this._bloomFilter.writeTo(outputStream);
        }
    }

    public void add(Object input) {
        this._bloomFilter.add(input.toString());
    }
}

