/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.fwd;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.pinot.$internal.org.apache.pinot.core.io.writer.impl.FixedByteSingleValueMultiColWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.SingleValueForwardIndexCreator;

public class SingleValueSortedForwardIndexCreator
implements SingleValueForwardIndexCreator {
    private final FixedByteSingleValueMultiColWriter _writer;
    private final int[] _minDocIds;
    private final int[] _maxDocIds;

    public SingleValueSortedForwardIndexCreator(File outputDir, String column, int cardinality) throws Exception {
        File indexFile = new File(outputDir, column + ".sv.sorted.fwd");
        this._writer = new FixedByteSingleValueMultiColWriter(indexFile, cardinality, 2, new int[]{4, 4});
        this._minDocIds = new int[cardinality];
        this._maxDocIds = new int[cardinality];
        Arrays.fill(this._minDocIds, Integer.MAX_VALUE);
        Arrays.fill(this._maxDocIds, Integer.MIN_VALUE);
    }

    @Override
    public void index(int docId, int dictId) {
        if (this._minDocIds[dictId] > docId) {
            this._minDocIds[dictId] = docId;
        }
        if (this._maxDocIds[dictId] < docId) {
            this._maxDocIds[dictId] = docId;
        }
    }

    @Override
    public void close() throws IOException {
        int cardinality = this._maxDocIds.length;
        for (int i = 0; i < cardinality; ++i) {
            this._writer.setInt(i, 0, this._minDocIds[i]);
            this._writer.setInt(i, 1, this._maxDocIds[i]);
        }
        this._writer.close();
    }
}

