/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats;

import java.util.HashSet;
import java.util.Set;
import org.apache.avro.reflect.Nullable;
import org.apache.pinot.$internal.org.apache.pinot.core.data.partition.PartitionFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.ColumnStatistics;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.StatsCollectorConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.V1Constants;
import org.apache.pinot.common.data.FieldSpec;

public abstract class AbstractColumnStatisticsCollector
implements ColumnStatistics {
    protected static final int INITIAL_HASH_SET_SIZE = 1000;
    private Object previousValue = null;
    protected final FieldSpec fieldSpec;
    private boolean isSorted = true;
    private final String column;
    protected int totalNumberOfEntries = 0;
    protected int maxNumberOfMultiValues = 0;
    private PartitionFunction partitionFunction;
    private final int numPartitions;
    private final Set<Integer> _partitions;

    void updateTotalNumberOfEntries(Object[] entries) {
        this.totalNumberOfEntries += entries.length;
    }

    @Override
    public int getTotalNumberOfEntries() {
        return this.totalNumberOfEntries;
    }

    public AbstractColumnStatisticsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        this.column = column;
        this.fieldSpec = statsCollectorConfig.getFieldSpecForColumn(column);
        this.partitionFunction = statsCollectorConfig.getPartitionFunction(column);
        this.numPartitions = statsCollectorConfig.getNumPartitions(column);
        this._partitions = this.partitionFunction != null ? new HashSet<Integer>() : null;
        this.addressNull(this.previousValue, this.fieldSpec.getDataType());
        this.previousValue = null;
    }

    @Override
    public int getMaxNumberOfMultiValues() {
        return this.maxNumberOfMultiValues;
    }

    void addressSorted(Object entry) {
        if (this.isSorted) {
            Comparable prevValue;
            Comparable origin;
            if (this.previousValue != null && !entry.equals(this.previousValue) && this.previousValue != null && (origin = (Comparable)entry).compareTo(prevValue = (Comparable)this.previousValue) < 0) {
                this.isSorted = false;
            }
            this.previousValue = entry;
        }
    }

    @Override
    public boolean isSorted() {
        return this.fieldSpec.isSingleValueField() && this.isSorted;
    }

    public abstract void collect(Object var1);

    public abstract void collect(Object var1, boolean var2);

    @Override
    public abstract Object getMinValue();

    @Override
    public abstract Object getMaxValue();

    @Override
    public abstract Object getUniqueValuesSet();

    @Override
    public abstract int getCardinality();

    @Override
    public int getLengthOfShortestElement() {
        return -1;
    }

    @Override
    public int getLengthOfLargestElement() {
        return -1;
    }

    public abstract void seal();

    Object addressNull(Object entry, FieldSpec.DataType e) {
        if (entry == null) {
            if (e == FieldSpec.DataType.STRING) {
                entry = "nil";
            } else if (e == FieldSpec.DataType.BOOLEAN) {
                entry = V1Constants.Str.NULL_BOOLEAN;
            } else if (e == FieldSpec.DataType.DOUBLE) {
                entry = V1Constants.Numbers.NULL_DOUBLE;
            } else if (e == FieldSpec.DataType.FLOAT) {
                entry = V1Constants.Numbers.NULL_FLOAT;
            } else if (e == FieldSpec.DataType.LONG) {
                entry = V1Constants.Numbers.NULL_LONG;
            } else if (e == FieldSpec.DataType.INT) {
                entry = V1Constants.Numbers.NULL_INT;
            }
        }
        return entry;
    }

    @Override
    public PartitionFunction getPartitionFunction() {
        return this.partitionFunction;
    }

    @Override
    public int getNumPartitions() {
        return this.numPartitions;
    }

    @Override
    @Nullable
    public Set<Integer> getPartitions() {
        return this._partitions;
    }

    protected void updatePartition(Object value) {
        if (this.partitionFunction != null) {
            this._partitions.add(this.partitionFunction.getPartition(value));
        }
    }
}

