/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.StatsCollectorConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats.AbstractColumnStatisticsCollector;
import org.apache.pinot.common.utils.primitive.ByteArray;

public class BytesColumnPredIndexStatsCollector
extends AbstractColumnStatisticsCollector {
    private ByteArray _min = null;
    private ByteArray _max = null;
    private int _lengthOfShortestEntry = Integer.MAX_VALUE;
    private int _lengthOfLongestEntry = 0;
    private final Set<ByteArray> _rawBytesSet = new HashSet<ByteArray>(1000);
    private final Set<ByteArray> _aggregateBytesSet = new HashSet<ByteArray>(1000);
    private ByteArray[] _sortedBytesList;
    private boolean _sealed = false;

    public BytesColumnPredIndexStatsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        super(column, statsCollectorConfig);
    }

    private void collectEntry(byte[] entry, Set<ByteArray> set) {
        ByteArray value = new ByteArray(entry);
        this.addressSorted(value);
        this.updatePartition(value);
        set.add(value);
        int valueLength = value.length();
        this._lengthOfShortestEntry = Math.min(this._lengthOfShortestEntry, valueLength);
        this._lengthOfLongestEntry = Math.max(this._lengthOfLongestEntry, valueLength);
        ++this.totalNumberOfEntries;
    }

    @Override
    public void collect(Object entry, boolean isAggregated) {
        assert (entry instanceof byte[]);
        if (isAggregated) {
            this.collectEntry((byte[])entry, this._aggregateBytesSet);
        } else {
            this.collectEntry((byte[])entry, this._rawBytesSet);
        }
    }

    @Override
    public void collect(Object entry) {
        this.collect(entry, false);
    }

    @Override
    public ByteArray getMinValue() {
        if (this._sealed) {
            return this._min;
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    @Override
    public ByteArray getMaxValue() {
        if (this._sealed) {
            return this._max;
        }
        throw new IllegalStateException("you must seal the collector first before asking for max value");
    }

    public ByteArray[] getUniqueValuesSet() {
        if (this._sealed) {
            return this._sortedBytesList;
        }
        throw new IllegalStateException("you must seal the collector first before asking for unique values set");
    }

    @Override
    public int getLengthOfShortestElement() {
        return this._lengthOfShortestEntry;
    }

    @Override
    public int getLengthOfLargestElement() {
        if (this._sealed) {
            return this._lengthOfLongestEntry;
        }
        throw new IllegalStateException("you must seal the collector first before asking for longest value");
    }

    @Override
    public int getCardinality() {
        if (this._sealed) {
            return this._sortedBytesList.length;
        }
        throw new IllegalStateException("you must seal the collector first before asking for cardinality");
    }

    @Override
    public boolean hasNull() {
        return false;
    }

    @Override
    public void seal() {
        this._sortedBytesList = this._rawBytesSet.toArray(new ByteArray[this._rawBytesSet.size()]);
        Arrays.sort(this._sortedBytesList);
        this._min = this._sortedBytesList[0];
        this._max = this._sortedBytesList[this._sortedBytesList.length - 1];
        if (!this._aggregateBytesSet.isEmpty()) {
            this._rawBytesSet.addAll(this._aggregateBytesSet);
            this._sortedBytesList = this._rawBytesSet.toArray(new ByteArray[this._rawBytesSet.size()]);
            Arrays.sort(this._sortedBytesList);
        }
        this._sealed = true;
    }
}

